/*###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto utiliza el magnometro, el acelerometro, el touch slider y el sensor de luz, asi como el uso del puerto serial para comunicar un celular con la pc atraves de un modulo HC-5 bluetooth.
**         This module contains user's application code.
**   Componentes     : GPIO, AnalogIn,mag,acc,sl.tsi
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :Carlos Daniel Yerena Mercado
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 24/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################
*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define LED_ON  0
#define LED_OFF 1
#define MMA8451_I2C_ADDRESS (0x1d<<1)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut greenLED(LED_GREEN);
DigitalOut redLED(LED_RED);
DigitalIn  sw1(PTC3);
DigitalIn  sw3(PTC12);
TSIAnalogSlider slider(PTB16, PTB17, 100);
AnalogIn  lightSense(PTE22);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
MAG3110 mag(PTE25, PTE24);
Ticker heartBeat;
Serial pc(USBTX, USBRX);
Serial blu(PTE0, PTE1);
SLCD slcd; 


/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
struct KL46_SENSOR_DATO {
    int     sw1State;
    int     sw3State;
    
    float   sliderPosition;
    
    float   lightSensor;
    
    int     magXVal;
    int     magYVal;
    float   magHeading;
    
    float   accXVal;
    float   accYVal;
    float   accZVal;
    
} sensorDato;

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void serialSensorDato(void);    
void ledFlashTick(void);

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/

int main()
{
    
    greenLED = LED_OFF;
    redLED = LED_OFF;
    
    
    heartBeat.attach(&ledFlashTick, 1.0); 
 
 
    
    pc.baud( 115200);
    blu.baud( 115200);
    pc.printf("Hello World\r\n");
 
    
    sw1.mode(PullUp);
    sw3.mode(PullUp);
 
    
   
 
 
     
    while(1)
    {
        sensorDato.sw1State = sw1;
        sensorDato.sw3State = sw3;
        
        sensorDato.sliderPosition = slider.readPercentage() * 100;
        
        sensorDato.lightSensor = lightSense;
        sensorDato.accXVal = acc.getAccX();
        sensorDato.accYVal = acc.getAccY();
        sensorDato.accZVal = acc.getAccZ();
 
        sensorDato.magXVal = mag.readVal(MAG_OUT_X_MSB);
        sensorDato.magYVal = mag.readVal(MAG_OUT_Y_MSB);
        sensorDato.magHeading = mag.getHeading();
                
        serialSensorDato();
        
        
        redLED = LED_ON;
        wait(.03);
        redLED = LED_OFF;
 
        wait(1);
    }  
}
/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
/*
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (Toggle the LED)
        counter = Rate;             // Restablece el contador
    } 
}
*/
/* END Events */   
/*
______________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
void serialSensorDato(void)
{
if(blu.readable())
{
pc.printf("%c",blu.getc());
  pc.printf("Switches:\r\n  SW1 = %d\r\n  SW3 = %d\r\n\r\n", sensorDato.sw1State, sensorDato.sw3State);
    pc.printf("Slider:\r\n %2.0f %% \r\n\r\n", sensorDato.sliderPosition);
    pc.printf("Sensor de luz:\r\n  %1.3f \r\n\r\n", sensorDato.lightSensor);
    pc.printf("Accelerometro:\r\n  X = %1.3f\r\n  Y = %1.3f\r\n  Z = %1.3f\r\n\r\n", sensorDato.accXVal, sensorDato.accYVal, sensorDato.accZVal);
    pc.printf("Magnetometro:\r\n  X = %d\r\n  Y = %d\r\n  Heading = %.2f  \r\n\r\n", sensorDato.magXVal, sensorDato.magYVal, sensorDato.magHeading);
    
    pc.printf("\r\n");
}
else
            {  if(pc.readable())
        {
            pc.getc();
        
            blu.printf("%c",pc.getc());
            slcd.printf("%c",pc.getc());
            
            
                  
        }       }
    
}    
 
 
void ledFlashTick(void)
{
    greenLED = !greenLED;
}

/* END Program */

/* END Mbed */