/** ###################################################################
**     Filename    : main.cpp
**     Project     : FRDM-KL46Z_HUMTEMPSENSOR
**     Component   : DHT22
**     Tool        : Mbed Compiler
**     Compiler    : GNU C Compiler
**     Abstract    :El programa esta diseñado para que atraves de una interfaz LCD
**                  el usuario decida en que escala leer la temperatura, ademas de que
**                  a traves de un LED RGB observar en que nivel de temperatura se  
**                  encuentra, Rojo:temp>32°C, naranja:27°C-31°C, verde: 20°C-26°C,cian:14°C-19°C
**                  morado:9°C-13°C y azul temp< 8°C
**                  La temepratura, humedad y punto de rocio se retornan en valores enteros.
**         
**     Author(s)   : Mayra Pérez Almazán
**
** ###################################################################*//*
*/

/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "DHT22.h"
#include "TextLCD.h"
#include "Keypad.h"
#include "RGBLed.h"
/*
:..
:  Definiciones
:...............................................................................
*/
#define  on 1
#define off 0
/*
+--------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
TextLCD lcd(PTD3,PTD2,PTD4,PTD6,PTD7,PTD5, TextLCD::LCD20x4); // RS RW E D4 D5 D6 D7 - conexión de la LCD 20X4
Keypad kpad(PTA17,PTA16,PTA15,PTA14,PTC8,PTC9,PTC10,PTC11); // COL 1 COL 2 COL3 COL 4 ROW 1 ROW 2 ROW 3 ROW 4 -terminales del teclado 4x4
DHT22 dht22(PTA13); //Incializa puerto del sensor
RGBLed myRGBled(PTA2,PTA1,PTA12); //Incializa puertos PWM del LED RGB
PwmOut Buzz(PTE31); //Incializa el PWM del buzzer

/*
+--------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
int hum=0,temp=0,faren=0,kelvin=0,rocio=0;
//Buzz=on;

char key;
int released = 1;
int i=0;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void leeteclado()
{
    //lcd.cls();
    key = kpad.ReadKey();
    
    if(key == '\0')
        released = 1;
    if((key != '\0') && (released == 1)) {
        Buzz=on;
    wait_ms(5);
    Buzz=off;
        lcd.printf("%c\n", key);
        released = 0;
    }
}

void enciendeRGB()
{
    if(temp>=32)
        {
            myRGBled.write(0.0,1.0,0.0); //rojo temp>32°C
        }
        else if((temp>=27) && (temp<=31))
        {
             myRGBled.write(0.2,1.0,0.0); //ambar/amarillo rojizo temp 
        }
        else if((temp>=20) && (temp<=26))
        {
             myRGBled.write(1.0,0.0,0.0); //verde
        }
        else if((temp>=14) && (temp<=19))
        {
             myRGBled.write(0.2,0.0,1.0); //cian
        }
        else if((temp>=9) &&( temp<=13))
        {
            
            myRGBled.write(0.0,0.2,1.0); //morado
        }
        else if(temp<=8)
        {
             myRGBled.write(0.0,0.0,1.0); //azul
        } 
        
}
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#===============================================================================
*/

int main()
{
    

    Buzz=off;
    lcd.printf("Eliga escala de temp");
    lcd.locate(1,1);
    lcd.printf("1- Celsius");
    lcd.locate(1,2);
    lcd.printf("2- Farenheit");
    lcd.locate(1,3);
    lcd.printf("3- Kelvin");
    wait(3);
    lcd.cls();
    lcd.printf("Ingrese su opcion");
    lcd.printf("  ");
    dht22.inicio() ;
    hum=dht22.leeHumedad()/10;
    temp=dht22.leeTemperatura()/10;
    faren=dht22.convertirCelsiusaFarenheit();
    kelvin=dht22.convertirCelsiusaKelvin();
    rocio=dht22.calculaPuntodeRocio();
    
    
    while(i!=2)
    {
        
   leeteclado();
   //enciendeRGB();
   
            if(key=='1')
           {
            lcd.cls();
            lcd.locate(1,0);
            lcd.printf("Temperatura: %i C",temp);
            lcd.locate(1,1);
            lcd.printf("Humedad: %i ",hum);
            lcd.locate(1,2);
            lcd.printf("P. de rocio: %i ",rocio);
            enciendeRGB();
            i=2;
        } 
        else if(key=='2') 
        {
            lcd.cls();
            lcd.locate(1,0);
            lcd.printf("Temperatura: %i F",faren);
            lcd.locate(1,1);
            lcd.printf("Humedad: %i",hum);
            lcd.locate(1,2);
            lcd.printf("P. de rocio: %i C",rocio);
            enciendeRGB();
            i=2;
        }
        else if(key=='3')
        {
            lcd.cls();
            lcd.locate(1,0);
            //temp=dht22.leeTemperatura()/10;
            lcd.printf("Temperatura: %i K",kelvin);
            lcd.locate(1,1);
            lcd.printf("Humedad: %i",hum);
            lcd.locate(1,2);
            lcd.printf("P. de rocio: %i C",rocio);
            enciendeRGB();
            i=2;
        }
        else if(key=='4' )
        {
            lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");  
        }
         else if(key=='5')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='6')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='7')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
        else if(key=='8')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
        else if(key=='9')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='0')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='A')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='B')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='C')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
        else if(key=='D')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='#')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }
         else if(key=='*')
         {
             lcd.cls();
            lcd.locate(5,1);
            lcd.printf("ERROR");
            wait(1);
            lcd.cls();
            lcd.printf("Igrese de nuevo su"); 
            lcd.locate(0,1);
            lcd.printf("opcion  ");
         }       
}

    

} //FIN DEL PROGRAMA


