/** ###################################################################
**     Filename    : DHT22.h
**     Project     : FRDM-KL46Z_TEMPHUMDHT22
**     Component   : DHT22
**     Tool        : Mbed Compiler
**     Compiler    : GNU C Compiler
**     Abstract    :
**         DHT22.h - contiene las funciones prototipo para la implementacion
**         de una comunicación con el sensor de temperatura y humedad digital (Tipo DHT22)
**         esta libreria puede ser modificada para su uso con algun otro componente compactible
**         como el DHT11, pero implementando algunos ajustes antes (debido a las especificaiones).
**     Settings    :
**     Contents    :
**         Temperatura (°C)     - int leeTemperatura();
**         Humedad              - leeHumedad();
**         Punto de rocio (°C)  - int calculaPuntodeRocio();
**         Celsius -> Farenheit - int convertirCelsiusaFarenheit();
**         Celsius -> Kelvin    - convertirCelsiusaKelvin();
**         
**     Author(s)   : Mayra Pérez Almazán
**
** ###################################################################*//*
*/

#ifndef MBED_DHT22_H
#define MBED_DHT22_H

#include "mbed.h"

class DHT22
{
private:

    int _temperatura,_humedad;
    PinName _data_pin;

public:

    DHT22(PinName);
    bool inicio();
    int leeTemperatura();
    int leeHumedad();
    int convertirCelsiusaFarenheit();
    int convertirCelsiusaKelvin();
    int calculaPuntodeRocio();
};

#endif