
#include "DHT22.h"


DHT22::DHT22(PinName pin)
{
    _data_pin = pin;
}

int DHT22::leeTemperatura()
{
    return _temperatura;
}

int DHT22::leeHumedad()
{
    return _humedad;
}

bool DHT22::inicio()
{
    /* ## F U N C I O N A M I E N T O ## */
    DigitalInOut DHT22(_data_pin); //Tenemos que fijar un pin que pueda comportarse como entrada/salida para comunicarnos con el sensor
    int dht22_dat [5]; //fijamos los 5 bytes que resiviremos de informacion 
    DHT22.output(); //Se configura el pin como salida
    DHT22.write(0); //Pulso en bajo, para activar la comunicación
    wait_ms(18); //Duración del pulso en bajo de 18ms
    DHT22.write(1); //Pulso en alto
    DHT22.input(); //Se configura el pin como entrada
    wait_us(40); //Duracion del pulso en alto que puede durar desde 20us a 40us
    wait_us(80); // Respuesta del sensor
    int i,j,result=0;
    for (i=0; i<5; i++) {
        result=0;
        for (j=0; j<8; j++) {
            while (DHT22);
            while (!DHT22);
            wait_us(50);
            int p;
            p=DHT22;
            p=p <<(7-j);
            result=result|p;
        }
        dht22_dat[i] = result;
    }
    /*40 bits que contienen la informacion
    1er byte= Humedad // Parte entera // dat[0]
    2do byte= Humedad // Parte decimal // dat[1]
    3er byte= Temperatura // Parte entera // dat[2]
    4to byte= Temperatura // Parte decimal //dat[3]
    5to byte= Confirmacion (Cheksum) // dat[4]
    */
    int dht22_check_sum;
    dht22_check_sum=dht22_dat[0]+dht22_dat[1]+dht22_dat[2]+dht22_dat[3];
    dht22_check_sum= dht22_check_sum%256;
    if (dht22_check_sum==dht22_dat[4]) 
    {
        _humedad=dht22_dat[0]*256+dht22_dat[1];
        _temperatura=dht22_dat[2]*256+dht22_dat[3];
        return true;
    }
    return false;
}

int DHT22::convertirCelsiusaFarenheit()
{
    int F=0;
    F=((_temperatura/10)*1.8)+32;
    return F;
}

int DHT22::convertirCelsiusaKelvin()
{
    int K=0;
    K=((_temperatura/10)+273.15);
    return K;
}
int DHT22::calculaPuntodeRocio()
{
    float A0= 373.15/(273.15 + (_temperatura/10));
    float SUM = -7.90298 * (A0-1);
    SUM += 5.02808 * log10(A0);
    SUM += -1.3816e-7 * (pow(10, (11.344*(1-1/A0)))-1) ;
    SUM += 8.1328e-3 * (pow(10,(-3.49149*(A0-1)))-1) ;
    SUM += log10(1013.246);
    float VP = pow(10, SUM-3) * (_humedad/10);
    float T = log(VP/0.61078);   // temp var
    return (241.88 * T) / (17.558-T);
}