#include "mbed.h"

// 2014.08.21 
// Brad Grissom
// This program successfully works for communicating to the Anthem PCB
// via the Sparkfun RS485 converter with a terminal program at 9600 Baud.

 
 
Serial pc(PB_6, PB_7); // tx, rx
DigitalOut LeftTX_EN(PA_12);
 
int main() {
    int get = 0;
    LeftTX_EN = 1;
    // ORIG:  pc.baud(9600);
    // The clock on the Anthem board is running faster than the Nucleo,
    // so one hack is to slow down our baud rate.  This runs at 9600 baud
    // on the scope.
    pc.baud(6400);
    
    while(1) {
        // pc.printf("U");    
        // wait_ms(10);
        
        LeftTX_EN = 0;
        wait_ms(1);
        get = pc.getc(); //+ 1;
        
        LeftTX_EN = 1;
        wait_ms(1);
        pc.putc(get);
        wait_ms(2);
    }
}