#include "hardware_F072.hpp"

static TIM_HandleTypeDef TimHandleBAG;

static void pwmout_write_BAG(pwmout_t* obj, float value) {
    TIM_OC_InitTypeDef sConfig;
    int channel = 0;
    int complementary_channel = 0;

    TimHandleBAG.Instance = (TIM_TypeDef *)(obj->pwm);

    if (value < (float)0.0) {
        value = 0.0;
    } else if (value > (float)1.0) {
        value = 1.0;
    }

    obj->pulse = (uint32_t)((float)obj->period * value);

    // Configure channels
    sConfig.OCMode       = TIM_OCMODE_PWM1;
    sConfig.Pulse        = obj->pulse;
    sConfig.OCPolarity   = TIM_OCPOLARITY_HIGH;
    sConfig.OCNPolarity  = TIM_OCNPOLARITY_HIGH;
    sConfig.OCFastMode   = TIM_OCFAST_DISABLE;
    sConfig.OCIdleState  = TIM_OCIDLESTATE_RESET;
    sConfig.OCNIdleState = TIM_OCNIDLESTATE_RESET;

    switch (obj->pin) {
        // Channels 1
        case PA_2:
        case PA_4:
        case PA_6:
        case PA_7:
        case PA_8:
        case PB_1:
        case PB_4:
        case PB_8:
        case PB_9:
        case PB_14:
        case PC_6:
            channel = TIM_CHANNEL_1;
            break;
        // Channels 1N
        case PA_1:
        case PB_6:
        case PB_7:
        case PB_13:
            channel = TIM_CHANNEL_1;
            complementary_channel = 1;
            break;
        // Channels 2
        case PA_3:
        case PA_9:
        case PB_5:
        case PB_15:
        case PC_7:
            channel = TIM_CHANNEL_2;
            break;
        // Channels 3
        case PA_10:
        case PB_0:
        case PC_8:
            channel = TIM_CHANNEL_3;
            break;
        // Channels 4
        case PA_11:
        case PC_9:
            channel = TIM_CHANNEL_4;
            break;
        default:
            return;
    }

    HAL_TIM_PWM_ConfigChannel(&TimHandleBAG, &sConfig, channel);

    if (complementary_channel) {
        HAL_TIMEx_PWMN_Start(&TimHandleBAG, channel);
    } else {
        HAL_TIM_PWM_Start(&TimHandleBAG, channel);
    }
}


void pwmout_period_ns(pwmout_t* obj, int us) {
    TimHandleBAG.Instance = (TIM_TypeDef *)(obj->pwm);

    float dc = pwmout_read(obj);

    __HAL_TIM_DISABLE(&TimHandleBAG);

    // Update the SystemCoreClock variable
    SystemCoreClockUpdate();

    TimHandleBAG.Init.Period        = us - 1;
    // BAG Orig:  TimHandle.Init.Prescaler     = (uint16_t)(SystemCoreClock / 1000000) - 1; // 1 µs tick
    TimHandleBAG.Init.Prescaler     = 0; // BAG 1 ns tick (?)
    TimHandleBAG.Init.ClockDivision = 0;
    TimHandleBAG.Init.CounterMode   = TIM_COUNTERMODE_UP;
    HAL_TIM_PWM_Init(&TimHandleBAG);

    // Set duty cycle again
    pwmout_write_BAG(obj, dc);

    // Save for future use
    obj->period = us;

    __HAL_TIM_ENABLE(&TimHandleBAG);
}


/* USED FOR THE F030 BOARD
// This code is based off:
// mbed/libraries/mbed/targets/hal/TARGET_STM/TARGET_NUCLEO_F030R8/pwmout_api.c  pwmout_period_us()
void pwmout_period_ns_NOT_USED(pwmout_t* obj, int us) {
    TIM_TypeDef *tim = (TIM_TypeDef *)(obj->pwm);
    TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
    float dc = pwmout_read(obj);

    TIM_Cmd(tim, DISABLE);

    obj->period = us;

    TIM_TimeBaseStructure.TIM_Period = obj->period - 1;
    // Orig code:  TIM_TimeBaseStructure.TIM_Prescaler = (uint16_t)(SystemCoreClock / 1000000) - 1; // 1 µs tick
    TIM_TimeBaseStructure.TIM_Prescaler = 0;  // BAG 1 ns tick (?)
    TIM_TimeBaseStructure.TIM_ClockDivision = 0;
    TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
    TIM_TimeBaseInit(tim, &TIM_TimeBaseStructure);

    // Set duty cycle again
    pwmout_write(obj, dc);

    TIM_ARRPreloadConfig(tim, ENABLE);

    TIM_Cmd(tim, ENABLE);
}
*/

