#include <cstddef>
#include <string.h>
#include "ToshibaTC62D723.hpp"

bool gSpiMode;
SPI* gSpiPtr = NULL;
DigitalOut gbbTRANS(PA_4); // Global bit bang TRANS (data) line

ToshibaTC62D723::ToshibaTC62D723(void)
 : _dataIn(NULL),
   _dataOut(NULL)
{
    memset(_channelBrightness, 0, sizeof(uint16_t) * NUM_CHANNELS);
}

ToshibaTC62D723::~ToshibaTC62D723(void)
{
    // Its good practice to clear memory in the destructor
    memset(_channelBrightness, 0, sizeof(uint16_t) * NUM_CHANNELS);
}

void ToshibaTC62D723::shiftBrightnessDataIn(const uint16_t p_brightness)
{
    // TODO check return code?
    s0(p_brightness);
}

void ToshibaTC62D723::outputBrightnessDataToLEDs(void)
{
    s1();
}

// S0 Command:
//      Needs only SCK and SIN (which are SPI_SCK and SPI_MOSI respectively).
//      This is because TRANS can be 0 for this command according to the datasheet.
int ToshibaTC62D723::s0(const uint16_t p_value)
{
    if (p_value > 0 ) {
        BAGINFO3("%x", p_value);
    } else {
        BAGINFO3(".");
    }

    // Command S0 and S1 share the same clock line, so we need to be
    // careful which mode we are in.  This avoids re-initializing these
    // pins if we are already in SPI mode.
    // WARNING: Re-initializing every time makes the MOSI line dirty and
    //          is wasteful for the CPU.
    if ( gSpiMode == false &&
         gSpiPtr  == NULL)
    {
        // We are not using MISO, this is a one-way bus
        gSpiPtr = new SPI(SPI_MOSI, NC, SPI_SCK);

        if (gSpiPtr == NULL) {
            printf("ERROR: Could not allocate SPI\n");
            return AERROR;
        }

        // Note: Polarity and phase are both 0 for the TC62D723FNG
        // For a graphical reminder on polarity and phase, visit:
        //     http://www.eetimes.com/document.asp?doc_id=1272534
        gSpiPtr->format(16, 0);
        // gSpiPtr->frequency(1000000);  // 1.5 MHz on the scope
        gSpiPtr->frequency(24000000); // 24 MHz
        gSpiMode = true;
    }
    gbbTRANS = 0; // Like an SPI slave select
    gSpiPtr->write(p_value);
    gbbTRANS = 1; // Like an SPI slave select

    return AOK;
}

void ToshibaTC62D723::s1(void)
{
    BAGINFO3("\nLATCH\n");

    int i = 0;
    int j = 0;

    gbbTRANS = 0;

    if ( gSpiMode == true &&
         gSpiPtr  != NULL)
    {
        delete gSpiPtr;
        gSpiPtr  = NULL;
        gSpiMode = false;
    }

    DigitalOut bbSCK (D13); // bit bang clock

    bbSCK    = 0; // Start off/low
    gbbTRANS = 1; // Set high

    // Loop 6 times = 3 clock cycles
    for (j=0; j<6; j++) { // Always use an even number here!
        // The order of these two lines matter!
        i == 0 ? i = 1 : i = 0;          // Toggle i
        i == 0 ? bbSCK = 0 : bbSCK = 1;  // Set SCK to the same value as i
    }
    gbbTRANS = 0; // Set low
}
