#include "mbed.h"
#include <stdio.h>
#include "anthem.hpp"
#include "hardware_F072.hpp"

// Definitions
#define PIN_41 PB_5
#define PIN_46 PB_9
#define PIN_32 PA_11
#define PIN_20 PB_2
#define HEX_ONE_THOUSAND (0x03E8)
const int SCLK_ENABLED = 0;

// Forward Declarations
void display_RthenGthenB_for_1_pixel(uint16_t xON, uint16_t yON);
void debug_printf(uint16_t xON, uint16_t yON, int colorRotate);

// Globals
LEDModule g_mod;
DigitalOut ENA(PIN_41);
DigitalOut ENB(PIN_46);
DigitalOut ENC(PIN_32);
DigitalOut EnSclk(PIN_20);


int main (int argc, char *argv[])
{
    uint16_t x = 0;
    uint16_t y = 0;

    ENA = 1;
    ENB = 1;
    ENC = 1;
    EnSclk = SCLK_ENABLED;

    // NOTE: 24MHz is half the 48MHz clock rate.  The PWM registers
    //       seem to only allow 24MHz at this point, so I'm matching
    //       the SPI bus speed to be the same.
    //
    //       1/24MHz  =>  1/(24*10^6)  =>  41.6*10^-9 second period,
    //       which means 41.6ns period and 20.8ns pulse width at
    //       50% duty cycle (which seems to be right for the SPI clock
    //       line as well as a reasonable choice for the PWM line).

    // PWMCLK
    pwmout_t outs;
    pwmout_init(&outs, PB_4);
    pwmout_period_ns(&outs, 2); // 24 MHz (not very clean on the scope)
    // pwmout_period_ns(&outs, 40); // 1.2 MHz on the scope
    // Very slow!  pwmout_period_us(&outs, 2);
    pwmout_write(&outs, 0.5f); // Duty cycle 50%


    for (y = 0; y < MODULE_WIDTH; y++) {
        for (x = 0; x < MODULE_HEIGHT; x++) {
            display_RthenGthenB_for_1_pixel(x, y);
        }
    }

    return 0;
}


// This will display 3 "images":
//
// For one pixel location only, it will:
//     - Red   LED of that pixel ON (all the rest off)
//     - Green LED of that pixel ON (all the rest off)
//     - Blue  LED of that pixel ON (all the rest off)
//
void display_RthenGthenB_for_1_pixel(uint16_t xON, uint16_t yON)
{
    PixelColor srcPix;
    const uint8_t brightness = 0x07;
    int colorRotate = 0; // 0=Red, 1=Green, 2=Blue
    uint16_t x = 0;
    uint16_t y = 0;

    for (colorRotate = 0; colorRotate < 3; colorRotate++) {
        debug_printf(xON, yON, colorRotate);
        for (y = 0; y < MODULE_WIDTH; y++) {
            for (x = 0; x < MODULE_HEIGHT; x++) {
                if ( (xON == x) &&  // Should this pixel be turned on?
                     (yON == y) )
                {
                    if (colorRotate == 0) {
                        srcPix._r = brightness;
                        srcPix._g = 0;
                        srcPix._b = 0;
                    } else if (colorRotate == 1) {
                        srcPix._r = 0;
                        srcPix._g = brightness;
                        srcPix._b = 0;
                    } else if (colorRotate == 2) {
                        srcPix._r = 0;
                        srcPix._g = 0;
                        srcPix._b = brightness;
                    }
                } else {
                    // This pixel should be turned off
                    srcPix._r = 0;
                    srcPix._g = 0;
                    srcPix._b = 0;
                }
                g_mod._sourceImage.setPixel(x, y, srcPix);
            }
        }
        g_mod.displayImage();
    }
}

void debug_printf(uint16_t x, uint16_t y, int color)
{
    if (color == 0) {
        BAGINFO3("\nPICTURE RED   x[%d] y[%d]", x, y);
    } else if (color == 1) {
        BAGINFO3("\nPICTURE GREEN x[%d] y[%d]", x, y);
    } else if (color == 2) {
        BAGINFO3("\nPICTURE BLUE  x[%d] y[%d]", x, y);
    }
}
