#ifndef __ANTHEM_DEFINES_H__
#define __ANTHEM_DEFINES_H__

// Global Definitions
#define AOK    (0)   // Anthem OK    (can't clobber global definiton)
#define AERROR (-1)  // Anthem ERROR (can't clobber global definiton)

#define  MODULE_WIDTH     (18)  // Module width  (i.e. this PCB is 20 X 20 pixels)
#define  MODULE_HEIGHT    (18)  // Module height (i.e. this PCB is 20 X 20 pixels)

#define  NUM_SCANGROUPS   (3)  // In the future maybe store this on the EEPROM?
// 18 X 18 Board
#define  NUM_LED_DRIVERS (21)  // 7 sections with 3 LED driver chips each on a 18 X 18 board
// 20 X 20 Board
// #define  NUM_LED_DRIVERS (27)  // 9 sections with 3 LED driver chips each on a 20 X 20 board

#define  PIXELS_PER_SCANGROUP (MODULE_WIDTH*MODULE_HEIGHT/NUM_SCANGROUPS)
// There are 3 LEDs per pixel
#define  LEDS_PER_SCANGROUP   (PIXELS_PER_SCANGROUP*3)
#define  LOW  (0)
#define  HIGH (1)

// Enable these for debugging
#define BAGINFO1(fmt, args...)  do { } while(0)
// #define BAGINFO1(fmt, args...) printf("BAGINFO1 (%s|%s()|%d): " fmt, __FILE__, __func__, __LINE__, ## args)
#define BAGINFO2(fmt, args...)  do { } while(0)
// #define BAGINFO2(fmt, args...) printf("BAGINFO2 (%s|%s()|%d): " fmt, __FILE__, __func__, __LINE__, ## args)
#define BAGINFO3(fmt, args...)  do { } while(0)
// #define BAGINFO3(fmt, args...) printf(fmt, ## args)

#endif // __ANTHEM_DEFINES_H__
