#ifndef __CONFIGS_H__
#define __CONFIGS_H__

#include <stdint.h>
#include "defines.hpp"

// FIXME populate this from the EEPROM

// NOTE:
//     Each "pixel" is three LEDs: Red, Green, Blue.  Each LED in a pixel can be
//     (and usually is!) driven by a different driver.  It is not as simple as a
//     pixel-to-driver mapping, it actually consists of 3 led-to-driver mappings.
typedef struct ColorDrv_t {
    uint8_t redDrv;
    uint8_t greenDrv;
    uint8_t blueDrv;
} ColorDrv;

// Pixel to LED driver mapping
static const ColorDrv g_pix2Drv[MODULE_WIDTH][MODULE_HEIGHT] =
{
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 2, 3, 1}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 5, 6, 4}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7}, { 8, 9, 7} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {24,25,23}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {27,28,26}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29}, {30,31,29} },
    { {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34} },
    { {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34}, {33,32,34} }
};


// Pixel to LED driver channel mapping
static const uint8_t g_pix2DrvChan[MODULE_WIDTH][MODULE_HEIGHT] =
{
    { 0, 0, 0,15,15,15, 0, 0, 0,15,15,15, 0, 0, 0,15,15,15},
    { 1, 1, 1,14,14,14, 1, 1, 1,14,14,14, 1, 1, 1,14,14,14},
    { 2, 2, 2,13,13,13, 2, 2, 2,13,13,13, 2, 2, 2,13,13,13},
    { 3, 3, 3,12,12,12, 3, 3, 3,12,12,12, 3, 3, 3,12,12,12},
    { 4, 4, 4,11,11,11, 4, 4, 4,11,11,11, 4, 4, 4,11,11,11},
    { 5, 5, 5,10,10,10, 5, 5, 5,10,10,10, 5, 5, 5,10,10,10},
    { 6, 6, 6, 9, 9, 9, 6, 6, 6, 9, 9, 9, 6, 6, 6, 9, 9, 9},
    { 7, 7, 7, 8, 8, 8, 7, 7, 7, 8, 8, 8, 7, 7, 7, 8, 8, 8},
    { 0, 0, 0,15,15,15, 0, 0, 0,15,15,15, 0, 0, 0,15,15,15},
    { 1, 1, 1,14,14,14, 1, 1, 1,14,14,14, 1, 1, 1,14,14,14},
    { 2, 2, 2,13,13,13, 2, 2, 2,13,13,13, 2, 2, 2,13,13,13},
    { 3, 3, 3,12,12,12, 3, 3, 3,12,12,12, 3, 3, 3,12,12,12},
    { 4, 4, 4,11,11,11, 4, 4, 4,11,11,11, 4, 4, 4,11,11,11},
    { 5, 5, 5,10,10,10, 5, 5, 5,10,10,10, 5, 5, 5,10,10,10},
    { 6, 6, 6, 9, 9, 9, 6, 6, 6, 9, 9, 9, 6, 6, 6, 9, 9, 9},
    { 7, 7, 7, 8, 8, 8, 7, 7, 7, 8, 8, 8, 7, 7, 7, 8, 8, 8},
    { 5, 5, 5, 4, 4, 4, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0},
    { 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9,10,10,10,11,11,11}
};


// Pixel to scan group mapping
static const uint8_t g_pix2ScanGroup[MODULE_WIDTH][MODULE_HEIGHT] =
{
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2},
    { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2}
};


// The driver numbers are based on the PCB schematic and they are connected to
// each other as shown below (i.e. #2 connected to #5 connected to #8...)
//
// Index, Driver Number
//
//    0,  2
//    1,  5
//    2,  8
//    3, 24
//    4, 27
//    5, 30
//    6, 33
//    7,  1
//    8,  4
//    9,  7
//   10, 23
//   11, 26
//   12, 29
//   13, 34
//   14,  3
//   15,  6
//   16,  9
//   17, 25
//   18, 28
//   19, 31
//   20, 32

// Debug driver chain
static const uint8_t g_dbgDrvChain[21] =
{
// Driver Number,  // Index
     2, //  0
     5, //  1
     8, //  2
    24, //  3
    27, //  4
    30, //  5
    33, //  6
     1, //  7
     4, //  8
     7, //  9
    23, // 10
    26, // 11
    29, // 12
    34, // 13
     3, // 14
     6, // 15
     9, // 16
    25, // 17
    28, // 18
    31, // 19
    32  // 20
};

// The problem is that in software we'll have the driver number from the
// pixel2Driver mapping and we'll need the index of the driver.  We could
// take the above mapping and create a translation routine (search for
// the driver number and return the index) OR we could instead make a
// little array where you lookup by using the driver number as the index
// and the value is the true index as shown above.
//
// This is like the reverse mapping of the above mapping.

static const uint8_t g_driverChain[35] =
{
        // Index = driver number
  0xFF, //     0 = No such driver
     7, //     1 =  7
     0, //     2 =  0
    14, //     3 = 14
     8, //     4 =  8
     1, //     5 =  1
    15, //     6 = 15
     9, //     7 =  9
     2, //     8 =  2
    16, //     9 = 16
  0xFF, //    10 = No such driver
  0xFF, //    11 = No such driver
  0xFF, //    12 = No such driver
  0xFF, //    13 = No such driver
  0xFF, //    14 = No such driver
  0xFF, //    15 = No such driver
  0xFF, //    16 = No such driver
  0xFF, //    17 = No such driver
  0xFF, //    18 = No such driver
  0xFF, //    19 = No such driver
  0xFF, //    20 = No such driver
  0xFF, //    21 = No such driver
  0xFF, //    22 = No such driver
    10, //    23 = 10
     3, //    24 = 3
    17, //    25 = 17
    11, //    26 = 11
     4, //    27 = 4
    18, //    28 = 18
    12, //    29 = 12
     5, //    30 = 5
    19, //    31 = 19
    20, //    32 = 20
     6, //    33 = 6
    13  //    34 = 13
};

#endif // __CONFIGS_H__
