#ifndef __ANTHEM_H__
#define __ANTHEM_H__

#include <stdint.h>
#include "defines.hpp"
#include "ToshibaTC62D723.hpp"

// CODING STANDARDS:
//      Local     variable: var
//      Global    variable: g_var
//      Paramater variable: p_var
//      Member    variable: _var

class LED {
    public:
        // Constructor
        LED(void);

        // Default Destructor
        virtual ~LED();

        // Members
        ToshibaTC62D723 *_ledDriver;

        // Member Functions
        float    getCalibrationFactor (void);
        void     setCalibrationFactor (float p_val);
        uint8_t  getDriverChannelNum  (void);
        void     setDriverChannelNum  (uint8_t p_val);
        uint16_t getBrightness        (void);
        void     setBrightness        (uint16_t p_val);


    private:
        // Private Member Variables
        float    _calibrationFactor;
        uint8_t  _driverChannelNum;
        uint16_t _brightness;

        // Private Member Functions
};


class LEDPixel {
    public:
        // Constructor
        LEDPixel(void);

        // Default Destructor
        virtual ~LEDPixel();

        // Members
        LED _redLED;
        LED _greenLED;
        LED _blueLED;

        // Member Functions
        float getCalibrationFactor(void);
        void  setCalibrationFactor(float p_cal);


    private:
        // Private Member Variables
        float _calibrationFactor;

        // Private Member Functions
};


class ScanGroup {
    public:
        // Constructor
        ScanGroup(void);

        // Default Destructor
        virtual ~ScanGroup();

        // Members
        ScanGroup *_nextScanGroup;

        // Member Functions
        void mapLEDsToDrivers(void);
        void addLED(LED *p_led);
        int getTransistorMCUPinNum(void);


    private:
        // Private Member Variables
        uint16_t _transistorMCUPinNum;
        LED *_LEDs[LEDS_PER_SCANGROUP];
        uint16_t _index; // Index into the _LEDs array

        // Private Member Functions
};


class PixelColor {
    public:
        // Constructor
        PixelColor(void);

        // Default Destructor
        virtual ~PixelColor();

        // Members
        uint8_t _r;
        uint8_t _g;
        uint8_t _b;

        // Member Functions


    private:
        // Private Member Variables

        // Private Member Functions
};


class Image {
    public:
        // Constructor
        Image(void);

        // Default Destructor
        virtual ~Image();

        // Members

        // Member Functions
        PixelColor getPixel(uint16_t x, uint16_t y);
        void setPixel(uint16_t x, uint16_t y, PixelColor p_pix);


    private:
        // Private Member Variables
        PixelColor _imgPixel[MODULE_WIDTH][MODULE_HEIGHT];

        // Private Member Functions
};


class LEDModule {
    public:
        // Constructor
        LEDModule(void);

        // Default Destructor
        virtual ~LEDModule();

        // Members
        Image   _sourceImage;

        // Member Functions
        void displayImage(void);


    private:
        // Private Member Variables
        uint8_t _rowNum;
        uint8_t _colNum;
        float   _moduleBrightness;
        float   _displayBrightness;
        ScanGroup _scanGroupArray[NUM_SCANGROUPS];
        ScanGroup *_currentScanGroup;
        ToshibaTC62D723 _ledDriverArray[NUM_LED_DRIVERS];
        ToshibaTC62D723 *_dataOutDriver; // This is at the begginging of the chain.
                                         // Data is shifted into this driver.
        ToshibaTC62D723 *_dataInDriver;  // This is at the end of the chain.
                                         // Error messages are received from this driver.
        LEDPixel _pixel        [MODULE_WIDTH][MODULE_HEIGHT];

        // Private Member Functions
        void adjustImage(void);
        void shiftBrightnessDataIn(void);
        void enableNextScanGroup(void);
        void setPinToValue(int p_pin, int p_val);
};


#endif // __ANTHEM_H__
