#ifndef __TOSHIBATC62D723_H__
#define __TOSHIBATC62D723_H__

#include "mbed.h"
#include <stdint.h>
#include "defines.hpp"

// TODO  Make this the parent class and have ToshibaTC62D723 inherit from it.
// class LEDDriver { };

class ToshibaTC62D723 {
    public:
        // Constructor
        ToshibaTC62D723(void);

        // Default Destructor
        virtual ~ToshibaTC62D723();

        // Members
        static const int NUM_CHANNELS = 16;
        uint16_t _channelBrightness[NUM_CHANNELS];
        ToshibaTC62D723 *_dataIn;
        ToshibaTC62D723 *_dataOut;

        // Member Functions
        static void shiftBrightnessDataIn(const uint16_t p_brightness);
        static void outputBrightnessDataToLEDs(void);


    private:
        // Private Member Variables

        // Private Member Functions
        static int  s0(const uint16_t p_value);
        static void s1(void);
};

#endif // __TOSHIBATC62D723_H__
