#include "mbed.h"
#include "gps_locate.h"
#include "sms_lib.h"
#include "MDM.h"

int main() {
    
    // While 1
        // Wait for OBJTRACK SMS
        // Get GPS Location, if timeout, send last known location
        // Send back SMS with location
    
    MDMSerial mdm;
    if(!init_sms_features(&mdm, "5554"))
        return 0;
    
    struct sms_data_t sms;
    char buf1[32];
    char buf2[256];
    sms.phone_num = buf1;
    sms.msg_buf = buf2;
    
    struct gps_data_t gps_data;
    memset(&gps_data, 0, sizeof(gps_data));
    
    while(1) {
        printf("Waiting for SMS\r\n");
        fflush(stdout);
        while(!read_sms(&sms));
        printf("Received sms from phone number: %s\r\n", sms.phone_num);
        printf("%s\r\n", sms.msg_buf);
        if(strncmp("OBJTRACK", sms.msg_buf, 5) == 0) {
            gps_locate(&gps_data, 10);
            printf("Sending GPS Location");
            fflush(stdout);
            snprintf(sms.msg_buf, 256, "My location is: https://maps.google.com/?q=%.5f,%.5f\r\n", gps_data.la, gps_data.lo);
            send_sms(&sms);
        }
    }
    
    return 0;
}