#include "sms_lib.h"

DigitalOut myled(LED);

static MDMSerial *mdm;

int init_sms_features(MDMSerial *_mdm, char* SIMPIN)
{
    mdm = _mdm;
    
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm->init(SIMPIN, &devStatus);
    mdm->dumpDevStatus(&devStatus);
    
    if (mdmOk) {
        mdmOk &= mdm->registerNet(&netStatus);
        mdm->dumpNetStatus(&netStatus);
    }
    
    return mdmOk;
}

int send_sms(struct sms_data_t *sms)
{
    
    if (!sms || !(sms->phone_num) || !(sms->msg_buf) || !mdm) {
        return 0;
    }
    
    return mdm->smsSend(sms->phone_num, sms->msg_buf);
}


int read_sms(struct sms_data_t *sms)
{
    if (!sms || !(sms->phone_num) || !(sms->msg_buf) || !mdm) {
        return 0;
    }
    
    int ix[1];
    int numReceivedSMS = mdm->smsList("REC UNREAD", ix, 1);
    
    if (numReceivedSMS >= 1 && mdm->smsRead(ix[0], sms->phone_num, sms->msg_buf, sizeof(sms->msg_buf))) {
        mdm->smsDelete(ix[0]);
        return 1;
    }
    
    return 0;
}