#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "C12832.h"
#include "MbedJSONValue.h"

EthernetInterface eth;
HTTPClient http;
char str[2048];
C12832 lcd(p5, p7, p6, p8, p11);
bool updateLEDs = false;
void timeoutCallback()
{
    updateLEDs = true;
}

int main() 
{
    BusIn joy(p15,p12,p13,p16);
    DigitalIn fire(p14);
    BusOut leds(LED1,LED2,LED3,LED4);
    Timeout timeout;
    
    timeout.attach(&timeoutCallback, 5);
 
    eth.init(); //Use DHCP
    eth.connect();
    
    int lastJoy = 0;
    while(1) 
    {
        int currentJoy = joy;
        if (currentJoy != lastJoy)
        {
            lastJoy = currentJoy;
            updateLEDs = true;
            
            char url[1024];
            sprintf(url, "https://dweet.io/dweet/for/modern-wheel?joy=%d", currentJoy);
            
            http.get(url, str, sizeof(str));
        }
        
        if (updateLEDs)
        {
            //GET data
            int ret = http.get("https://dweet.io/get/latest/dweet/for/modern-wheel", str, sizeof(str));
            if (!ret)
            {
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("read %d", strlen(str));
                MbedJSONValue v;
                const char* start = str;
                const char* end = (const char*)(str + strlen(str));
                std::string err;
                parse(v, start, end, &err);
                if (!err.empty()) 
                {
                    lcd.cls();
                    lcd.printf("Error - %s", err.c_str());
                }
                else
                {
                    lcd.cls();
                    int joyValue = v["with"][0]["content"]["joy"].get<int>();
                    if (fire) 
                    {
                        leds=0xf;
                    } 
                    else 
                    {
                        leds=joyValue;
                    }
                }
            }
            else
            {
              lcd.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
            }
        }        
        updateLEDs = false;
        
    }
    eth.disconnect();  
}
