/*!
 *****************************************************************************
  @file:  thermcouple_lut.cpp

  @brief:

  @details:
 -----------------------------------------------------------------------------
 Copyright (c) 2018, 2020 Analog Devices, Inc.  All rights reserved.

 This software is proprietary to Analog Devices, Inc. and its licensors.
 By using this software you agree to the terms of the associated
 Analog Devices Software License Agreement.

*****************************************************************************/

#include "thermocouple.h"


#ifdef TYPE_B_LUT
const int16_t Thermocouple_Type_B::lut_offset = 0;
const uint16_t Thermocouple_Type_B::lut_size = 1820;
const int32_t Thermocouple_Type_B::lut[1820] = {
	-3,       -3,       -3,       -3,       -3,       -3,       -3,       -2,       -2,       -2,
		-2,       -2,       -2,       -2,       -2,       -2,       -2,       -2,       -2,       -2,
		-2,       -2,       -2,       -2,       -2,       -2,       -2,       -1,       -1,       -1,
		-1,       -1,       -1,       -1,       -1,       -1,       -1,        0,        0,        0,
		0,        0,        0,        0,        1,        1,        1,        2,        2,        2,
		3,        3,        3,        4,        4,        4,        5,        5,        6,        6,
		7,        7,        8,        8,        9,        9,       10,       10,       11,       11,
		12,       12,       13,       14,       14,       15,       15,       16,       17,       17,
		18,       19,       20,       20,       21,       22,       22,       23,       24,       25,
		26,       26,       27,       28,       29,       30,       31,       31,       32,       33,
		34,       35,       36,       37,       38,       39,       40,       41,       42,       43,
		44,       45,       46,       47,       48,       49,       50,       51,       52,       53,
		55,       56,       57,       58,       59,       60,       62,       63,       64,       65,
		66,       68,       69,       70,       72,       73,       74,       75,       77,       78,
		79,       81,       82,       84,       85,       86,       88,       89,       91,       92,
		94,       95,       96,       98,       99,      101,      102,      104,      106,      107,
		109,      110,      112,      113,      115,      117,      118,      120,      122,      123,
		125,      127,      128,      130,      132,      134,      135,      137,      139,      141,
		142,      144,      146,      148,      150,      151,      153,      155,      157,      159,
		161,      163,      165,      166,      168,      170,      172,      174,      176,      178,
		180,      182,      184,      186,      188,      190,      192,      195,      197,      199,
		201,      203,      205,      207,      209,      212,      214,      216,      218,      220,
		222,      225,      227,      229,      231,      234,      236,      238,      241,      243,
		245,      248,      250,      252,      255,      257,      259,      262,      264,      267,
		269,      271,      274,      276,      279,      281,      284,      286,      289,      291,
		294,      296,      299,      301,      304,      307,      309,      312,      314,      317,
		320,      322,      325,      328,      330,      333,      336,      338,      341,      344,
		347,      349,      352,      355,      358,      360,      363,      366,      369,      372,
		375,      377,      380,      383,      386,      389,      392,      395,      398,      401,
		404,      407,      410,      413,      416,      419,      422,      425,      428,      431,
		434,      437,      440,      443,      446,      449,      452,      455,      458,      462,
		465,      468,      471,      474,      478,      481,      484,      487,      490,      494,
		497,      500,      503,      507,      510,      513,      517,      520,      523,      527,
		530,      533,      537,      540,      544,      547,      550,      554,      557,      561,
		564,      568,      571,      575,      578,      582,      585,      589,      592,      596,
		599,      603,      607,      610,      614,      617,      621,      625,      628,      632,
		636,      639,      643,      647,      650,      654,      658,      662,      665,      669,
		673,      677,      680,      684,      688,      692,      696,      700,      703,      707,
		711,      715,      719,      723,      727,      731,      735,      738,      742,      746,
		750,      754,      758,      762,      766,      770,      774,      778,      782,      787,
		791,      795,      799,      803,      807,      811,      815,      819,      824,      828,
		832,      836,      840,      844,      849,      853,      857,      861,      866,      870,
		874,      878,      883,      887,      891,      896,      900,      904,      909,      913,
		917,      922,      926,      930,      935,      939,      944,      948,      953,      957,
		961,      966,      970,      975,      979,      984,      988,      993,      997,     1002,
		1006,     1010,     1016,     1020,     1025,     1030,     1034,     1039,     1043,     1048,
		1053,     1057,     1062,     1067,     1071,     1076,     1081,     1086,     1090,     1095,
		1100,     1105,     1109,     1114,     1119,     1124,     1129,     1133,     1138,     1143,
		1148,     1153,     1158,     1163,     1167,     1172,     1177,     1182,     1187,     1192,
		1197,     1202,     1207,     1212,     1217,     1222,     1227,     1232,     1237,     1242,
		1247,     1252,     1257,     1262,     1267,     1272,     1277,     1282,     1288,     1293,
		1298,     1303,     1308,     1313,     1318,     1324,     1329,     1334,     1339,     1344,
		1350,     1355,     1360,     1365,     1371,     1376,     1381,     1387,     1392,     1397,
		1402,     1408,     1413,     1418,     1424,     1429,     1435,     1440,     1445,     1451,
		1456,     1462,     1467,     1472,     1478,     1483,     1489,     1494,     1500,     1505,
		1511,     1516,     1522,     1527,     1533,     1539,     1544,     1550,     1555,     1561,
		1566,     1572,     1578,     1583,     1589,     1595,     1600,     1606,     1612,     1617,
		1623,     1629,     1634,     1640,     1646,     1652,     1657,     1663,     1669,     1675,
		1680,     1686,     1692,     1698,     1704,     1709,     1715,     1721,     1727,     1733,
		1739,     1745,     1750,     1756,     1762,     1768,     1774,     1780,     1786,     1792,
		1798,     1804,     1810,     1816,     1822,     1828,     1834,     1840,     1846,     1852,
		1858,     1864,     1870,     1876,     1882,     1888,     1894,     1901,     1907,     1913,
		1919,     1925,     1931,     1937,     1944,     1950,     1956,     1962,     1968,     1975,
		1981,     1987,     1993,     1999,     2005,     2012,     2017,     2025,     2031,     2037,
		2043,     2050,     2056,     2062,     2069,     2075,     2082,     2088,     2094,     2101,
		2107,     2113,     2120,     2126,     2133,     2139,     2146,     2152,     2158,     2165,
		2171,     2178,     2184,     2191,     2197,     2204,     2210,     2217,     2224,     2230,
		2237,     2243,     2250,     2256,     2263,     2270,     2276,     2283,     2289,     2296,
		2303,     2309,     2316,     2323,     2329,     2336,     2343,     2350,     2356,     2363,
		2370,     2376,     2383,     2390,     2397,     2403,     2410,     2417,     2424,     2431,
		2437,     2444,     2451,     2458,     2465,     2472,     2479,     2485,     2492,     2499,
		2506,     2513,     2520,     2527,     2534,     2541,     2548,     2555,     2562,     2569,
		2576,     2583,     2590,     2597,     2604,     2611,     2618,     2625,     2632,     2639,
		2646,     2653,     2660,     2667,     2674,     2681,     2688,     2696,     2703,     2710,
		2717,     2724,     2731,     2738,     2746,     2753,     2760,     2767,     2775,     2782,
		2789,     2796,     2803,     2811,     2818,     2825,     2833,     2840,     2847,     2854,
		2862,     2869,     2876,     2884,     2891,     2898,     2906,     2913,     2921,     2928,
		2935,     2943,     2950,     2958,     2965,     2973,     2980,     2987,     2995,     3002,
		3010,     3017,     3025,     3032,     3040,     3047,     3055,     3062,     3070,     3078,
		3085,     3093,     3100,     3108,     3116,     3123,     3131,     3138,     3146,     3154,
		3161,     3169,     3177,     3184,     3192,     3200,     3207,     3215,     3223,     3230,
		3238,     3246,     3254,     3261,     3269,     3277,     3285,     3292,     3300,     3308,
		3316,     3324,     3331,     3339,     3347,     3355,     3363,     3371,     3379,     3386,
		3394,     3402,     3410,     3418,     3426,     3434,     3442,     3450,     3458,     3466,
		3474,     3482,     3490,     3498,     3506,     3514,     3522,     3530,     3538,     3546,
		3554,     3562,     3570,     3578,     3586,     3594,     3602,     3610,     3618,     3626,
		3634,     3643,     3651,     3659,     3667,     3675,     3683,     3692,     3700,     3708,
		3716,     3724,     3732,     3741,     3749,     3757,     3765,     3774,     3782,     3790,
		3798,     3807,     3815,     3823,     3832,     3840,     3848,     3857,     3865,     3873,
		3882,     3890,     3898,     3907,     3915,     3923,     3932,     3940,     3949,     3957,
		3965,     3974,     3982,     3991,     3999,     4008,     4016,     4024,     4033,     4041,
		4050,     4058,     4067,     4075,     4083,     4093,     4101,     4110,     4118,     4127,
		4135,     4144,     4152,     4161,     4170,     4178,     4187,     4195,     4204,     4213,
		4221,     4230,     4239,     4247,     4256,     4265,     4273,     4282,     4291,     4299,
		4308,     4317,     4326,     4334,     4343,     4352,     4360,     4369,     4378,     4387,
		4396,     4404,     4413,     4422,     4431,     4440,     4448,     4457,     4466,     4475,
		4484,     4493,     4501,     4510,     4519,     4528,     4537,     4546,     4555,     4564,
		4573,     4582,     4591,     4599,     4608,     4617,     4626,     4635,     4644,     4653,
		4662,     4671,     4680,     4689,     4698,     4707,     4716,     4725,     4734,     4743,
		4753,     4762,     4771,     4780,     4789,     4798,     4807,     4816,     4825,     4834,
		4843,     4853,     4862,     4871,     4880,     4889,     4898,     4908,     4917,     4926,
		4935,     4944,     4954,     4963,     4972,     4981,     4990,     5000,     5009,     5018,
		5027,     5037,     5046,     5055,     5065,     5074,     5083,     5092,     5102,     5111,
		5120,     5130,     5139,     5148,     5158,     5167,     5176,     5186,     5195,     5205,
		5214,     5223,     5233,     5242,     5252,     5261,     5270,     5280,     5289,     5299,
		5308,     5318,     5327,     5337,     5346,     5356,     5365,     5375,     5384,     5394,
		5403,     5413,     5422,     5432,     5441,     5451,     5460,     5470,     5480,     5489,
		5499,     5508,     5518,     5528,     5537,     5547,     5556,     5566,     5576,     5585,
		5595,     5605,     5614,     5624,     5634,     5643,     5653,     5663,     5672,     5682,
		5692,     5702,     5711,     5721,     5731,     5740,     5750,     5760,     5770,     5780,
		5789,     5799,     5809,     5819,     5828,     5838,     5848,     5858,     5868,     5878,
		5887,     5897,     5907,     5917,     5927,     5937,     5947,     5956,     5966,     5976,
		5986,     5996,     6006,     6016,     6026,     6036,     6046,     6055,     6065,     6075,
		6085,     6095,     6105,     6115,     6125,     6135,     6145,     6155,     6165,     6175,
		6185,     6195,     6205,     6215,     6225,     6235,     6245,     6256,     6266,     6276,
		6286,     6296,     6306,     6316,     6326,     6336,     6346,     6356,     6367,     6377,
		6387,     6397,     6407,     6417,     6427,     6438,     6448,     6458,     6468,     6478,
		6488,     6499,     6509,     6519,     6529,     6539,     6550,     6560,     6570,     6580,
		6591,     6601,     6611,     6621,     6632,     6642,     6652,     6663,     6673,     6683,
		6693,     6704,     6714,     6724,     6735,     6745,     6755,     6766,     6776,     6786,
		6797,     6807,     6818,     6828,     6838,     6849,     6859,     6869,     6880,     6890,
		6901,     6911,     6922,     6932,     6942,     6953,     6963,     6974,     6984,     6995,
		7005,     7016,     7026,     7037,     7047,     7058,     7068,     7079,     7089,     7100,
		7110,     7121,     7131,     7142,     7152,     7163,     7173,     7184,     7194,     7205,
		7216,     7226,     7237,     7247,     7258,     7269,     7279,     7290,     7300,     7311,
		7322,     7332,     7343,     7353,     7364,     7375,     7385,     7396,     7407,     7417,
		7428,     7439,     7449,     7460,     7471,     7482,     7492,     7503,     7514,     7524,
		7535,     7546,     7557,     7567,     7578,     7589,     7600,     7610,     7621,     7632,
		7643,     7653,     7664,     7675,     7686,     7697,     7707,     7718,     7729,     7740,
		7751,     7761,     7772,     7783,     7794,     7805,     7816,     7827,     7837,     7848,
		7859,     7870,     7881,     7892,     7903,     7914,     7924,     7935,     7946,     7957,
		7968,     7979,     7990,     8000,     8012,     8023,     8034,     8045,     8055,     8066,
		8077,     8087,     8099,     8109,     8121,     8132,     8143,     8154,     8164,     8176,
		8186,     8198,     8209,     8220,     8231,     8242,     8253,     8264,     8275,     8286,
		8298,     8309,     8320,     8331,     8342,     8353,     8364,     8375,     8386,     8397,
		8408,     8419,     8430,     8441,     8453,     8464,     8475,     8486,     8497,     8508,
		8519,     8530,     8542,     8553,     8564,     8575,     8586,     8597,     8608,     8620,
		8631,     8642,     8653,     8664,     8675,     8687,     8698,     8709,     8720,     8731,
		8743,     8754,     8765,     8776,     8787,     8799,     8810,     8821,     8832,     8844,
		8855,     8866,     8877,     8889,     8900,     8911,     8922,     8934,     8945,     8956,
		8967,     8979,     8990,     9001,     9013,     9024,     9035,     9047,     9058,     9069,
		9080,     9092,     9103,     9114,     9126,     9137,     9148,     9160,     9171,     9182,
		9194,     9205,     9216,     9228,     9239,     9251,     9262,     9273,     9285,     9296,
		9307,     9319,     9330,     9342,     9353,     9364,     9376,     9387,     9398,     9410,
		9421,     9433,     9444,     9456,     9467,     9478,     9490,     9501,     9513,     9524,
		9536,     9547,     9558,     9570,     9581,     9593,     9604,     9616,     9627,     9639,
		9650,     9662,     9673,     9684,     9696,     9707,     9719,     9730,     9742,     9753,
		9765,     9776,     9788,     9799,     9811,     9822,     9834,     9845,     9857,     9868,
		9880,     9891,     9903,     9914,     9926,     9937,     9949,     9961,     9972,     9984,
		9995,    10007,    10018,    10030,    10041,    10053,    10064,    10076,    10088,    10099,
		10111,    10122,    10134,    10145,    10157,    10168,    10180,    10192,    10203,    10215,
		10226,    10238,    10249,    10261,    10273,    10284,    10296,    10307,    10319,    10331,
		10342,    10354,    10365,    10377,    10389,    10400,    10412,    10423,    10435,    10447,
		10458,    10470,    10482,    10493,    10505,    10516,    10528,    10540,    10551,    10563,
		10575,    10586,    10598,    10609,    10621,    10633,    10644,    10656,    10668,    10679,
		10691,    10703,    10714,    10726,    10738,    10749,    10761,    10773,    10784,    10796,
		10808,    10819,    10831,    10843,    10854,    10866,    10877,    10889,    10901,    10913,
		10924,    10936,    10948,    10959,    10971,    10983,    10994,    11006,    11018,    11029,
		11041,    11053,    11064,    11076,    11088,    11099,    11111,    11123,    11134,    11146,
		11158,    11169,    11181,    11193,    11205,    11216,    11228,    11240,    11251,    11263,
		11275,    11286,    11298,    11310,    11321,    11333,    11345,    11357,    11368,    11380,
		11392,    11403,    11415,    11427,    11438,    11450,    11462,    11474,    11485,    11497,
		11509,    11520,    11532,    11544,    11555,    11567,    11579,    11591,    11602,    11614,
		11626,    11637,    11649,    11661,    11673,    11684,    11696,    11708,    11719,    11731,
		11743,    11754,    11766,    11778,    11790,    11801,    11813,    11825,    11836,    11848,
		11860,    11871,    11883,    11895,    11907,    11918,    11930,    11942,    11953,    11965,
		11977,    11988,    12000,    12012,    12024,    12035,    12047,    12059,    12070,    12082,
		12094,    12105,    12117,    12129,    12141,    12152,    12164,    12176,    12187,    12199,
		12211,    12222,    12234,    12246,    12257,    12269,    12281,    12292,    12304,    12316,
		12327,    12339,    12351,    12363,    12374,    12386,    12398,    12409,    12421,    12433,
		12444,    12456,    12468,    12479,    12491,    12503,    12514,    12526,    12538,    12549,
		12561,    12572,    12584,    12596,    12607,    12619,    12631,    12642,    12654,    12666,
		12677,    12689,    12701,    12712,    12724,    12736,    12747,    12759,    12770,    12782,
		12794,    12805,    12817,    12829,    12840,    12852,    12863,    12875,    12887,    12898,
		12910,    12921,    12933,    12945,    12956,    12968,    12980,    12991,    13003,    13014,
		13026,    13037,    13049,    13061,    13072,    13084,    13095,    13107,    13119,    13130,
		13142,    13153,    13165,    13176,    13188,    13200,    13211,    13223,    13234,    13246,
		13257,    13269,    13280,    13292,    13304,    13315,    13327,    13338,    13350,    13361,
		13373,    13384,    13396,    13407,    13419,    13430,    13442,    13453,    13465,    13476,
		13488,    13499,    13511,    13522,    13534,    13545,    13557,    13568,    13580,    13591,
		13603,    13614,    13626,    13637,    13649,    13660,    13672,    13683,    13694,    13706,
		13717,    13729,    13740,    13752,    13763,    13775,    13786,    13797,    13809,    13820,
	};
#endif

#ifdef TYPE_E_LUT
const int16_t Thermocouple_Type_E::lut_offset = -270;
const uint16_t Thermocouple_Type_E::lut_size = 1270;
const int32_t Thermocouple_Type_E::lut[1270] = {
	-9835,    -9833,    -9831,    -9828,    -9825,    -9821,    -9817,    -9813,    -9808,    -9802,
		-9797,    -9790,    -9784,    -9777,    -9770,    -9762,    -9754,    -9746,    -9737,    -9728,
		-9718,    -9709,    -9698,    -9688,    -9677,    -9666,    -9654,    -9642,    -9630,    -9617,
		-9604,    -9591,    -9577,    -9563,    -9548,    -9534,    -9519,    -9503,    -9487,    -9471,
		-9455,    -9438,    -9421,    -9404,    -9386,    -9368,    -9350,    -9331,    -9313,    -9293,
		-9274,    -9254,    -9234,    -9214,    -9193,    -9172,    -9151,    -9129,    -9107,    -9085,
		-9063,    -9040,    -9017,    -8994,    -8971,    -8947,    -8923,    -8899,    -8874,    -8850,
		-8825,    -8799,    -8774,    -8748,    -8722,    -8696,    -8669,    -8643,    -8616,    -8588,
		-8561,    -8533,    -8505,    -8477,    -8449,    -8420,    -8391,    -8362,    -8333,    -8303,
		-8273,    -8243,    -8213,    -8183,    -8151,    -8121,    -8090,    -8058,    -8026,    -7995,
		-7963,    -7931,    -7899,    -7866,    -7833,    -7800,    -7767,    -7733,    -7700,    -7666,
		-7632,    -7597,    -7563,    -7528,    -7493,    -7458,    -7423,    -7387,    -7351,    -7315,
		-7279,    -7243,    -7206,    -7170,    -7133,    -7096,    -7058,    -7021,    -6983,    -6945,
		-6907,    -6869,    -6831,    -6792,    -6753,    -6714,    -6675,    -6636,    -6596,    -6556,
		-6516,    -6476,    -6436,    -6396,    -6355,    -6314,    -6273,    -6232,    -6191,    -6149,
		-6107,    -6065,    -6023,    -5981,    -5939,    -5896,    -5853,    -5810,    -5767,    -5724,
		-5681,    -5637,    -5593,    -5549,    -5505,    -5461,    -5417,    -5372,    -5327,    -5282,
		-5237,    -5192,    -5147,    -5101,    -5055,    -5009,    -4963,    -4917,    -4871,    -4824,
		-4777,    -4731,    -4684,    -4636,    -4589,    -4542,    -4494,    -4446,    -4398,    -4350,
		-4302,    -4254,    -4205,    -4156,    -4107,    -4058,    -4009,    -3960,    -3911,    -3861,
		-3811,    -3761,    -3711,    -3661,    -3611,    -3561,    -3510,    -3459,    -3408,    -3357,
		-3306,    -3255,    -3204,    -3152,    -3100,    -3048,    -2996,    -2944,    -2892,    -2840,
		-2787,    -2735,    -2682,    -2629,    -2576,    -2523,    -2469,    -2416,    -2362,    -2309,
		-2255,    -2201,    -2147,    -2093,    -2037,    -1984,    -1929,    -1874,    -1820,    -1765,
		-1709,    -1654,    -1599,    -1543,    -1488,    -1432,    -1376,    -1320,    -1264,    -1208,
		-1152,    -1095,    -1039,     -982,     -925,     -868,     -811,     -754,     -697,     -639,
		-582,     -524,     -466,     -408,     -350,     -292,     -234,     -176,     -117,      -59,
		59,      118,      176,      235,      294,      354,      413,      472,      532,      591,
		651,      711,      770,      830,      890,      950,     1010,     1071,     1131,     1192,
		1252,     1313,     1373,     1434,     1495,     1556,     1617,     1678,     1740,     1801,
		1862,     1924,     1986,     2047,     2109,     2171,     2233,     2295,     2357,     2420,
		2482,     2545,     2607,     2670,     2733,     2795,     2858,     2921,     2984,     3048,
		3111,     3174,     3238,     3301,     3365,     3429,     3492,     3556,     3620,     3685,
		3749,     3813,     3877,     3942,     4006,     4070,     4136,     4200,     4265,     4330,
		4395,     4460,     4526,     4591,     4656,     4722,     4788,     4853,     4919,     4985,
		5051,     5117,     5183,     5249,     5315,     5382,     5448,     5514,     5581,     5648,
		5714,     5781,     5848,     5915,     5982,     6049,     6117,     6184,     6251,     6319,
		6386,     6454,     6522,     6590,     6658,     6725,     6794,     6862,     6930,     6998,
		7066,     7135,     7203,     7272,     7341,     7409,     7478,     7547,     7616,     7685,
		7754,     7823,     7892,     7962,     8031,     8101,     8170,     8240,     8309,     8379,
		8449,     8519,     8589,     8659,     8729,     8799,     8869,     8940,     9010,     9081,
		9151,     9222,     9292,     9363,     9434,     9505,     9576,     9647,     9718,     9789,
		9860,     9931,    10003,    10074,    10145,    10217,    10288,    10360,    10432,    10503,
		10575,    10647,    10719,    10791,    10863,    10935,    11007,    11080,    11152,    11224,
		11297,    11369,    11442,    11514,    11587,    11660,    11733,    11805,    11878,    11951,
		12024,    12097,    12170,    12243,    12317,    12390,    12463,    12537,    12610,    12684,
		12757,    12831,    12904,    12978,    13052,    13126,    13199,    13273,    13347,    13421,
		13495,    13569,    13644,    13718,    13792,    13866,    13941,    14015,    14090,    14164,
		14239,    14313,    14388,    14463,    14537,    14612,    14687,    14762,    14837,    14912,
		14987,    15062,    15137,    15212,    15287,    15362,    15438,    15513,    15588,    15664,
		15739,    15815,    15890,    15966,    16041,    16117,    16193,    16268,    16344,    16420,
		16496,    16572,    16648,    16724,    16800,    16876,    16952,    17028,    17104,    17181,
		17257,    17333,    17409,    17486,    17562,    17639,    17715,    17792,    17868,    17945,
		18021,    18098,    18175,    18252,    18328,    18405,    18482,    18559,    18636,    18713,
		18790,    18867,    18944,    19021,    19098,    19175,    19252,    19330,    19407,    19484,
		19561,    19639,    19716,    19794,    19871,    19948,    20026,    20103,    20181,    20259,
		20336,    20414,    20492,    20569,    20647,    20725,    20803,    20880,    20958,    21036,
		21114,    21192,    21270,    21348,    21426,    21504,    21582,    21660,    21739,    21817,
		21895,    21973,    22051,    22130,    22208,    22286,    22365,    22443,    22522,    22600,
		22678,    22757,    22835,    22914,    22993,    23071,    23150,    23228,    23307,    23386,
		23464,    23543,    23622,    23701,    23780,    23858,    23937,    24016,    24095,    24174,
		24253,    24332,    24411,    24490,    24569,    24648,    24727,    24806,    24885,    24964,
		25044,    25123,    25202,    25281,    25360,    25440,    25519,    25598,    25678,    25757,
		25836,    25916,    25995,    26075,    26154,    26233,    26313,    26392,    26472,    26552,
		26631,    26711,    26790,    26870,    26950,    27029,    27109,    27189,    27268,    27348,
		27428,    27507,    27587,    27667,    27747,    27827,    27907,    27986,    28066,    28146,
		28226,    28306,    28386,    28466,    28546,    28626,    28706,    28786,    28866,    28946,
		29026,    29106,    29186,    29266,    29346,    29427,    29507,    29587,    29667,    29747,
		29827,    29908,    29988,    30068,    30148,    30229,    30309,    30389,    30470,    30550,
		30630,    30711,    30791,    30871,    30952,    31032,    31112,    31193,    31273,    31354,
		31434,    31515,    31595,    31676,    31756,    31837,    31917,    31998,    32078,    32159,
		32238,    32320,    32400,    32481,    32561,    32642,    32723,    32803,    32884,    32965,
		33045,    33126,    33207,    33287,    33368,    33449,    33529,    33610,    33691,    33772,
		33852,    33933,    34014,    34095,    34175,    34256,    34337,    34418,    34498,    34579,
		34660,    34741,    34822,    34902,    34983,    35064,    35145,    35226,    35307,    35387,
		35468,    35549,    35630,    35711,    35792,    35873,    35954,    36034,    36115,    36196,
		36277,    36358,    36439,    36520,    36601,    36682,    36763,    36843,    36924,    37005,
		37086,    37167,    37248,    37329,    37410,    37491,    37572,    37653,    37734,    37815,
		37896,    37977,    38058,    38139,    38220,    38300,    38381,    38462,    38543,    38624,
		38705,    38786,    38867,    38948,    39029,    39110,    39191,    39272,    39353,    39434,
		39515,    39596,    39677,    39758,    39839,    39920,    40001,    40082,    40163,    40243,
		40324,    40405,    40486,    40567,    40648,    40729,    40810,    40891,    40972,    41053,
		41134,    41215,    41296,    41377,    41457,    41538,    41619,    41700,    41781,    41862,
		41943,    42024,    42105,    42185,    42266,    42347,    42428,    42509,    42590,    42671,
		42751,    42832,    42913,    42994,    43075,    43156,    43236,    43317,    43398,    43479,
		43560,    43640,    43721,    43802,    43883,    43963,    44044,    44125,    44206,    44286,
		44367,    44448,    44529,    44609,    44690,    44771,    44851,    44932,    45013,    45093,
		45174,    45255,    45335,    45416,    45497,    45577,    45658,    45738,    45819,    45900,
		45980,    46061,    46141,    46222,    46302,    46383,    46463,    46544,    46624,    46705,
		46785,    46866,    46946,    47027,    47107,    47188,    47268,    47349,    47429,    47509,
		47590,    47670,    47751,    47831,    47911,    47992,    48072,    48152,    48233,    48313,
		48393,    48474,    48554,    48634,    48715,    48795,    48875,    48955,    49035,    49116,
		49196,    49276,    49356,    49436,    49517,    49597,    49677,    49757,    49837,    49917,
		49997,    50077,    50157,    50238,    50318,    50398,    50478,    50558,    50638,    50718,
		50798,    50878,    50958,    51038,    51118,    51197,    51277,    51357,    51437,    51517,
		51597,    51677,    51757,    51837,    51916,    51996,    52076,    52156,    52236,    52315,
		52395,    52475,    52555,    52634,    52714,    52794,    52873,    52953,    53033,    53112,
		53192,    53272,    53351,    53431,    53510,    53590,    53670,    53749,    53829,    53908,
		53988,    54067,    54147,    54226,    54306,    54385,    54465,    54544,    54624,    54703,
		54782,    54862,    54941,    55021,    55100,    55179,    55259,    55338,    55417,    55497,
		55576,    55655,    55734,    55814,    55893,    55972,    56051,    56131,    56210,    56289,
		56368,    56447,    56526,    56606,    56685,    56764,    56843,    56922,    57001,    57080,
		57159,    57238,    57317,    57396,    57475,    57554,    57633,    57712,    57791,    57870,
		57949,    58028,    58107,    58186,    58265,    58343,    58422,    58501,    58580,    58659,
		58738,    58816,    58895,    58974,    59053,    59131,    59210,    59289,    59367,    59446,
		59525,    59604,    59682,    59761,    59839,    59918,    59997,    60075,    60154,    60232,
		60311,    60390,    60468,    60547,    60625,    60704,    60782,    60860,    60939,    61017,
		61096,    61174,    61253,    61331,    61409,    61488,    61566,    61644,    61723,    61801,
		61879,    61958,    62036,    62114,    62192,    62271,    62349,    62427,    62505,    62583,
		62662,    62740,    62818,    62896,    62974,    63052,    63130,    63208,    63286,    63364,
		63442,    63520,    63598,    63676,    63754,    63832,    63910,    63988,    64066,    64144,
		64221,    64300,    64376,    64455,    64533,    64611,    64688,    64766,    64843,    64922,
		65000,    65077,    65155,    65233,    65310,    65388,    65465,    65543,    65621,    65698,
		65776,    65853,    65931,    66008,    66086,    66163,    66241,    66318,    66396,    66473,
		66550,    66628,    66705,    66782,    66860,    66937,    67014,    67092,    67169,    67246,
		67323,    67400,    67478,    67555,    67632,    67709,    67786,    67863,    67940,    68017,
		68094,    68171,    68248,    68325,    68402,    68479,    68556,    68633,    68710,    68787,
		68863,    68940,    69017,    69094,    69171,    69247,    69324,    69401,    69477,    69554,
		69631,    69707,    69784,    69860,    69937,    70013,    70090,    70166,    70243,    70319,
		70396,    70472,    70548,    70625,    70701,    70777,    70854,    70930,    71006,    71082,
		71159,    71235,    71311,    71387,    71463,    71539,    71615,    71692,    71768,    71844,
		71920,    71996,    72072,    72147,    72223,    72299,    72375,    72451,    72527,    72603,
		72678,    72754,    72830,    72906,    72981,    73057,    73133,    73208,    73284,    73360,
		73435,    73511,    73586,    73662,    73738,    73813,    73889,    73964,    74040,    74115,
		74190,    74266,    74341,    74417,    74492,    74567,    74643,    74718,    74793,    74869,
		74944,    75019,    75095,    75170,    75245,    75320,    75395,    75471,    75546,    75621,
		75696,    75771,    75847,    75922,    75997,    76072,    76147,    76223,    76298,    76373,
	};
#endif

#ifdef TYPE_J_LUT
const int16_t Thermocouple_Type_J::lut_offset = -210;
const uint16_t Thermocouple_Type_J::lut_size = 1410;
const int32_t Thermocouple_Type_J::lut[1410] = {
	-8095,    -8076,    -8057,    -8037,    -8016,    -7996,    -7976,    -7955,    -7934,    -7912,
		-7890,    -7868,    -7846,    -7824,    -7801,    -7778,    -7755,    -7731,    -7707,    -7683,
		-7659,    -7634,    -7610,    -7585,    -7559,    -7534,    -7508,    -7482,    -7456,    -7429,
		-7403,    -7376,    -7348,    -7321,    -7293,    -7265,    -7237,    -7209,    -7181,    -7152,
		-7123,    -7094,    -7064,    -7035,    -7005,    -6975,    -6944,    -6914,    -6883,    -6853,
		-6821,    -6790,    -6759,    -6727,    -6695,    -6663,    -6631,    -6598,    -6566,    -6533,
		-6500,    -6467,    -6433,    -6400,    -6366,    -6332,    -6298,    -6263,    -6229,    -6194,
		-6159,    -6124,    -6089,    -6054,    -6018,    -5982,    -5946,    -5910,    -5874,    -5838,
		-5801,    -5764,    -5727,    -5690,    -5653,    -5616,    -5578,    -5541,    -5503,    -5465,
		-5426,    -5388,    -5350,    -5311,    -5272,    -5233,    -5194,    -5155,    -5116,    -5076,
		-5037,    -4997,    -4957,    -4917,    -4877,    -4836,    -4796,    -4755,    -4714,    -4674,
		-4633,    -4591,    -4550,    -4509,    -4467,    -4425,    -4384,    -4342,    -4300,    -4257,
		-4215,    -4173,    -4130,    -4088,    -4045,    -4002,    -3959,    -3916,    -3872,    -3829,
		-3786,    -3742,    -3698,    -3654,    -3610,    -3566,    -3522,    -3478,    -3434,    -3389,
		-3344,    -3300,    -3255,    -3210,    -3165,    -3120,    -3075,    -3029,    -2984,    -2938,
		-2893,    -2847,    -2801,    -2755,    -2709,    -2663,    -2617,    -2571,    -2524,    -2478,
		-2431,    -2385,    -2338,    -2291,    -2244,    -2197,    -2150,    -2103,    -2055,    -2008,
		-1961,    -1913,    -1865,    -1818,    -1770,    -1722,    -1674,    -1626,    -1578,    -1530,
		-1482,    -1433,    -1385,    -1336,    -1288,    -1239,    -1190,    -1142,    -1093,    -1044,
		-995,     -946,     -896,     -847,     -798,     -749,     -699,     -650,     -600,     -550,
		-501,     -451,     -401,     -351,     -301,     -251,     -201,     -151,     -101,      -50,
		50,      101,      151,      202,      253,      303,      354,      405,      456,      507,
		558,      609,      660,      711,      762,      814,      865,      916,      968,     1018,
		1071,     1122,     1174,     1226,     1277,     1329,     1381,     1433,     1485,     1537,
		1589,     1641,     1693,     1745,     1797,     1849,     1902,     1954,     2005,     2059,
		2111,     2164,     2216,     2269,     2322,     2374,     2427,     2480,     2532,     2585,
		2638,     2691,     2744,     2797,     2850,     2903,     2956,     3009,     3062,     3116,
		3169,     3222,     3275,     3329,     3382,     3436,     3489,     3543,     3596,     3650,
		3703,     3757,     3810,     3864,     3918,     3971,     4025,     4078,     4133,     4187,
		4240,     4294,     4348,     4402,     4456,     4510,     4564,     4618,     4672,     4726,
		4781,     4835,     4889,     4943,     4997,     5052,     5106,     5160,     5215,     5269,
		5323,     5378,     5432,     5487,     5541,     5595,     5650,     5705,     5759,     5814,
		5868,     5923,     5977,     6032,     6087,     6141,     6196,     6251,     6306,     6360,
		6415,     6470,     6525,     6579,     6634,     6689,     6744,     6799,     6854,     6909,
		6964,     7019,     7074,     7129,     7184,     7239,     7294,     7349,     7404,     7459,
		7514,     7569,     7624,     7679,     7734,     7789,     7844,     7900,     7955,     8010,
		8064,     8119,     8175,     8231,     8286,     8341,     8396,     8452,     8507,     8562,
		8618,     8673,     8728,     8783,     8839,     8894,     8949,     9005,     9060,     9115,
		9171,     9226,     9282,     9337,     9392,     9448,     9503,     9559,     9614,     9669,
		9725,     9780,     9836,     9891,     9947,    10002,    10057,    10113,    10168,    10224,
		10279,    10335,    10390,    10446,    10501,    10557,    10612,    10668,    10723,    10779,
		10834,    10890,    10945,    11001,    11056,    11112,    11167,    11223,    11278,    11334,
		11389,    11445,    11501,    11556,    11612,    11667,    11723,    11778,    11834,    11889,
		11945,    12000,    12056,    12111,    12167,    12222,    12278,    12334,    12389,    12445,
		12500,    12556,    12611,    12667,    12722,    12778,    12833,    12889,    12944,    13000,
		13056,    13111,    13167,    13222,    13278,    13333,    13389,    13444,    13500,    13555,
		13611,    13666,    13722,    13777,    13833,    13888,    13944,    13999,    14055,    14110,
		14166,    14221,    14277,    14332,    14388,    14443,    14499,    14554,    14609,    14665,
		14720,    14776,    14831,    14887,    14942,    14998,    15053,    15109,    15164,    15219,
		15275,    15330,    15386,    15441,    15496,    15552,    15607,    15663,    15718,    15773,
		15829,    15884,    15940,    15995,    16050,    16106,    16161,    16216,    16271,    16327,
		16383,    16438,    16493,    16549,    16604,    16659,    16715,    16770,    16825,    16881,
		16936,    16991,    17046,    17102,    17157,    17212,    17268,    17323,    17378,    17434,
		17489,    17544,    17599,    17655,    17710,    17765,    17820,    17876,    17931,    17986,
		18041,    18097,    18152,    18207,    18262,    18318,    18373,    18428,    18483,    18538,
		18594,    18649,    18704,    18759,    18814,    18870,    18925,    18980,    19035,    19090,
		19146,    19201,    19256,    19311,    19366,    19422,    19477,    19532,    19587,    19642,
		19697,    19753,    19808,    19863,    19918,    19973,    20028,    20083,    20139,    20194,
		20249,    20304,    20359,    20414,    20469,    20525,    20580,    20635,    20690,    20745,
		20800,    20855,    20911,    20966,    21021,    21076,    21131,    21186,    21241,    21297,
		21352,    21407,    21462,    21517,    21572,    21627,    21683,    21738,    21793,    21848,
		21903,    21958,    22014,    22069,    22124,    22179,    22234,    22289,    22345,    22400,
		22455,    22510,    22565,    22620,    22676,    22731,    22786,    22841,    22896,    22952,
		23007,    23062,    23117,    23172,    23228,    23283,    23338,    23393,    23449,    23504,
		23559,    23614,    23670,    23725,    23780,    23835,    23891,    23946,    24001,    24057,
		24112,    24167,    24223,    24278,    24333,    24389,    24444,    24499,    24555,    24610,
		24665,    24721,    24776,    24832,    24887,    24943,    24998,    25053,    25109,    25164,
		25220,    25275,    25331,    25386,    25442,    25497,    25553,    25608,    25664,    25720,
		25775,    25831,    25886,    25942,    25998,    26053,    26109,    26165,    26220,    26276,
		26332,    26387,    26443,    26499,    26555,    26610,    26666,    26722,    26778,    26834,
		26889,    26945,    27001,    27057,    27113,    27169,    27225,    27281,    27337,    27393,
		27449,    27505,    27561,    27617,    27673,    27729,    27785,    27841,    27897,    27953,
		28010,    28066,    28122,    28178,    28234,    28291,    28347,    28403,    28460,    28516,
		28572,    28629,    28685,    28741,    28798,    28854,    28911,    28967,    29024,    29080,
		29137,    29194,    29250,    29307,    29363,    29420,    29477,    29534,    29590,    29647,
		29704,    29761,    29818,    29874,    29931,    29988,    30045,    30102,    30159,    30216,
		30273,    30330,    30387,    30444,    30502,    30559,    30616,    30673,    30730,    30788,
		30845,    30902,    30960,    31017,    31074,    31132,    31189,    31247,    31304,    31362,
		31419,    31477,    31535,    31592,    31650,    31708,    31766,    31823,    31881,    31939,
		31997,    32055,    32113,    32171,    32229,    32287,    32345,    32403,    32461,    32519,
		32577,    32636,    32694,    32752,    32810,    32869,    32927,    32985,    33044,    33102,
		33161,    33219,    33278,    33337,    33395,    33454,    33513,    33571,    33630,    33689,
		33748,    33807,    33866,    33925,    33984,    34043,    34102,    34161,    34220,    34279,
		34338,    34397,    34457,    34516,    34575,    34635,    34694,    34754,    34813,    34873,
		34932,    34992,    35051,    35111,    35171,    35230,    35290,    35350,    35410,    35470,
		35530,    35590,    35650,    35710,    35770,    35830,    35890,    35950,    36010,    36071,
		36131,    36191,    36252,    36312,    36373,    36433,    36494,    36554,    36615,    36675,
		36736,    36797,    36858,    36918,    36979,    37040,    37101,    37162,    37223,    37284,
		37345,    37406,    37467,    37528,    37590,    37651,    37712,    37773,    37835,    37896,
		37958,    38019,    38081,    38142,    38204,    38265,    38327,    38389,    38450,    38512,
		38574,    38636,    38698,    38760,    38822,    38884,    38946,    39008,    39070,    39132,
		39194,    39256,    39318,    39381,    39443,    39505,    39568,    39630,    39693,    39755,
		39818,    39880,    39943,    40005,    40068,    40131,    40193,    40256,    40319,    40382,
		40445,    40508,    40570,    40633,    40696,    40759,    40822,    40886,    40949,    41012,
		41075,    41138,    41201,    41265,    41328,    41391,    41455,    41518,    41581,    41645,
		41708,    41772,    41835,    41899,    41962,    42026,    42090,    42153,    42217,    42281,
		42344,    42408,    42472,    42536,    42599,    42663,    42727,    42791,    42855,    42919,
		42983,    43047,    43111,    43175,    43239,    43303,    43367,    43431,    43495,    43559,
		43624,    43688,    43752,    43817,    43881,    43945,    44010,    44074,    44139,    44203,
		44267,    44332,    44396,    44461,    44525,    44590,    44655,    44719,    44784,    44848,
		44913,    44977,    45042,    45107,    45171,    45236,    45301,    45365,    45430,    45494,
		45559,    45624,    45688,    45753,    45818,    45882,    45947,    46011,    46076,    46141,
		46205,    46270,    46334,    46399,    46464,    46528,    46593,    46657,    46722,    46786,
		46851,    46915,    46980,    47044,    47109,    47173,    47238,    47302,    47367,    47431,
		47495,    47560,    47624,    47688,    47753,    47817,    47881,    47946,    48010,    48074,
		48138,    48202,    48267,    48331,    48395,    48459,    48523,    48587,    48651,    48715,
		48779,    48843,    48907,    48971,    49034,    49098,    49162,    49226,    49290,    49353,
		49417,    49481,    49544,    49608,    49672,    49735,    49799,    49862,    49926,    49989,
		50052,    50116,    50179,    50243,    50306,    50369,    50432,    50495,    50559,    50622,
		50685,    50748,    50811,    50874,    50937,    51000,    51063,    51126,    51188,    51251,
		51314,    51377,    51439,    51502,    51565,    51627,    51690,    51752,    51815,    51877,
		51940,    52002,    52064,    52127,    52189,    52251,    52314,    52376,    52438,    52500,
		52562,    52624,    52686,    52748,    52810,    52872,    52934,    52996,    53057,    53119,
		53181,    53243,    53304,    53366,    53427,    53489,    53550,    53612,    53673,    53735,
		53796,    53857,    53919,    53980,    54041,    54102,    54164,    54225,    54286,    54347,
		54408,    54469,    54530,    54591,    54652,    54713,    54773,    54834,    54895,    54956,
		55016,    55077,    55138,    55198,    55259,    55319,    55380,    55440,    55501,    55561,
		55622,    55682,    55742,    55803,    55863,    55923,    55983,    56043,    56104,    56164,
		56224,    56284,    56344,    56404,    56464,    56524,    56584,    56643,    56703,    56763,
		56823,    56883,    56942,    57002,    57062,    57121,    57181,    57240,    57300,    57360,
		57419,    57479,    57538,    57597,    57657,    57716,    57776,    57835,    57894,    57953,
		58013,    58072,    58131,    58190,    58249,    58309,    58368,    58427,    58486,    58545,
		58604,    58663,    58722,    58781,    58840,    58899,    58957,    59016,    59075,    59134,
		59193,    59252,    59310,    59369,    59428,    59487,    59545,    59604,    59663,    59721,
		59780,    59838,    59897,    59956,    60014,    60073,    60131,    60190,    60248,    60307,
		60365,    60423,    60482,    60540,    60599,    60657,    60715,    60774,    60832,    60890,
		60949,    61007,    61065,    61123,    61182,    61240,    61298,    61356,    61415,    61473,
		61531,    61589,    61647,    61705,    61763,    61822,    61880,    61938,    61996,    62054,
		62112,    62170,    62228,    62286,    62344,    62402,    62460,    62518,    62576,    62634,
		62692,    62750,    62808,    62866,    62924,    62982,    63040,    63098,    63156,    63214,
		63271,    63329,    63387,    63445,    63503,    63561,    63619,    63677,    63734,    63792,
		63850,    63908,    63966,    64024,    64081,    64138,    64197,    64254,    64313,    64370,
		64428,    64486,    64544,    64602,    64659,    64717,    64775,    64833,    64890,    64947,
		65006,    65063,    65120,    65179,    65236,    65295,    65352,    65410,    65468,    65525,
		65583,    65641,    65699,    65756,    65814,    65872,    65929,    65987,    66045,    66102,
		66160,    66218,    66275,    66333,    66391,    66448,    66506,    66564,    66621,    66679,
		66737,    66794,    66852,    66910,    66967,    67025,    67082,    67140,    67198,    67255,
		67313,    67370,    67428,    67486,    67543,    67601,    67658,    67716,    67773,    67831,
		67888,    67946,    68003,    68061,    68119,    68176,    68234,    68291,    68348,    68406,
		68463,    68521,    68578,    68636,    68693,    68751,    68808,    68865,    68923,    68980,
		69037,    69095,    69152,    69209,    69267,    69324,    69381,    69439,    69496,    69553,
	};
#endif

#ifdef TYPE_K_LUT
const int16_t Thermocouple_Type_K::lut_offset = -270;
const uint16_t Thermocouple_Type_K::lut_size = 1642;
const int32_t Thermocouple_Type_K::lut[1642] = {
	-6458,    -6457,    -6456,    -6455,    -6453,    -6452,    -6450,    -6448,    -6446,    -6444,
		-6441,    -6438,    -6435,    -6432,    -6429,    -6425,    -6421,    -6417,    -6413,    -6408,
		-6404,    -6399,    -6393,    -6388,    -6382,    -6377,    -6370,    -6364,    -6358,    -6351,
		-6344,    -6337,    -6329,    -6322,    -6314,    -6306,    -6297,    -6289,    -6280,    -6271,
		-6262,    -6252,    -6243,    -6233,    -6223,    -6213,    -6202,    -6192,    -6181,    -6170,
		-6158,    -6147,    -6135,    -6123,    -6111,    -6099,    -6087,    -6074,    -6061,    -6048,
		-6035,    -6021,    -6007,    -5994,    -5980,    -5965,    -5951,    -5936,    -5922,    -5907,
		-5891,    -5876,    -5861,    -5845,    -5829,    -5813,    -5797,    -5780,    -5763,    -5747,
		-5730,    -5713,    -5695,    -5678,    -5660,    -5642,    -5624,    -5606,    -5588,    -5569,
		-5550,    -5531,    -5512,    -5493,    -5474,    -5454,    -5435,    -5415,    -5395,    -5374,
		-5354,    -5333,    -5313,    -5292,    -5271,    -5250,    -5228,    -5207,    -5185,    -5163,
		-5141,    -5119,    -5097,    -5074,    -5052,    -5029,    -5006,    -4983,    -4960,    -4936,
		-4913,    -4889,    -4865,    -4841,    -4817,    -4793,    -4768,    -4744,    -4719,    -4694,
		-4669,    -4644,    -4618,    -4593,    -4567,    -4542,    -4516,    -4490,    -4463,    -4437,
		-4411,    -4384,    -4357,    -4330,    -4303,    -4276,    -4249,    -4221,    -4194,    -4166,
		-4138,    -4110,    -4082,    -4054,    -4025,    -3997,    -3968,    -3939,    -3911,    -3882,
		-3852,    -3823,    -3794,    -3764,    -3734,    -3705,    -3675,    -3645,    -3614,    -3584,
		-3554,    -3523,    -3492,    -3462,    -3431,    -3400,    -3368,    -3337,    -3306,    -3274,
		-3243,    -3211,    -3179,    -3147,    -3115,    -3083,    -3050,    -3018,    -2986,    -2953,
		-2920,    -2887,    -2854,    -2821,    -2788,    -2755,    -2721,    -2688,    -2654,    -2620,
		-2587,    -2553,    -2519,    -2485,    -2450,    -2416,    -2382,    -2347,    -2312,    -2278,
		-2243,    -2208,    -2173,    -2138,    -2103,    -2067,    -2032,    -1996,    -1961,    -1925,
		-1889,    -1854,    -1818,    -1782,    -1745,    -1709,    -1673,    -1637,    -1600,    -1564,
		-1527,    -1490,    -1453,    -1417,    -1380,    -1343,    -1305,    -1268,    -1231,    -1194,
		-1156,    -1119,    -1081,    -1043,    -1006,     -968,     -930,     -892,     -854,     -816,
		-778,     -739,     -701,     -663,     -624,     -586,     -547,     -508,     -470,     -431,
		-392,     -353,     -314,     -275,     -236,     -197,     -157,     -118,      -79,      -39,
		39,       79,      119,      158,      198,      238,      277,      317,      357,      397,
		437,      477,      517,      557,      597,      637,      677,      718,      758,      798,
		838,      879,      919,      960,     1000,     1041,     1081,     1122,     1163,     1203,
		1244,     1285,     1326,     1366,     1407,     1448,     1489,     1530,     1571,     1612,
		1653,     1694,     1735,     1776,     1817,     1858,     1899,     1941,     1982,     2023,
		2064,     2106,     2147,     2188,     2230,     2271,     2312,     2354,     2395,     2436,
		2478,     2519,     2561,     2602,     2644,     2685,     2727,     2768,     2810,     2851,
		2893,     2934,     2976,     3017,     3059,     3100,     3142,     3184,     3225,     3267,
		3308,     3350,     3391,     3433,     3474,     3516,     3557,     3599,     3640,     3682,
		3723,     3765,     3806,     3848,     3889,     3931,     3972,     4013,     4054,     4096,
		4138,     4179,     4220,     4262,     4303,     4344,     4385,     4427,     4468,     4509,
		4550,     4591,     4633,     4674,     4715,     4756,     4797,     4838,     4879,     4920,
		4961,     5002,     5043,     5084,     5124,     5165,     5206,     5247,     5288,     5328,
		5369,     5410,     5450,     5491,     5532,     5572,     5613,     5653,     5694,     5735,
		5775,     5815,     5856,     5896,     5937,     5977,     6017,     6058,     6098,     6138,
		6179,     6219,     6259,     6299,     6339,     6380,     6420,     6460,     6500,     6540,
		6580,     6620,     6660,     6701,     6741,     6781,     6821,     6861,     6901,     6941,
		6981,     7021,     7060,     7100,     7140,     7180,     7220,     7260,     7300,     7340,
		7380,     7420,     7460,     7500,     7540,     7579,     7619,     7659,     7699,     7739,
		7779,     7819,     7859,     7899,     7939,     7979,     8019,     8058,     8099,     8138,
		8178,     8218,     8258,     8298,     8338,     8378,     8418,     8458,     8499,     8539,
		8579,     8619,     8659,     8699,     8739,     8779,     8819,     8860,     8900,     8940,
		8980,     9020,     9061,     9101,     9141,     9181,     9222,     9262,     9302,     9343,
		9383,     9423,     9464,     9504,     9545,     9585,     9626,     9666,     9707,     9747,
		9788,     9828,     9869,     9909,     9950,     9991,    10031,    10072,    10113,    10153,
		10194,    10235,    10276,    10316,    10357,    10398,    10439,    10480,    10520,    10561,
		10602,    10643,    10684,    10725,    10766,    10807,    10848,    10889,    10930,    10971,
		11012,    11053,    11094,    11135,    11176,    11217,    11259,    11300,    11341,    11382,
		11423,    11465,    11506,    11547,    11588,    11630,    11671,    11712,    11753,    11795,
		11836,    11877,    11919,    11960,    12001,    12043,    12084,    12126,    12167,    12209,
		12250,    12291,    12333,    12374,    12416,    12457,    12499,    12540,    12582,    12624,
		12665,    12707,    12748,    12790,    12831,    12873,    12915,    12956,    12998,    13040,
		13081,    13123,    13165,    13206,    13248,    13290,    13331,    13373,    13415,    13457,
		13498,    13540,    13582,    13624,    13665,    13707,    13749,    13791,    13833,    13874,
		13916,    13958,    14000,    14042,    14084,    14126,    14167,    14209,    14251,    14293,
		14335,    14377,    14419,    14461,    14503,    14545,    14587,    14629,    14671,    14713,
		14755,    14797,    14839,    14881,    14923,    14965,    15007,    15049,    15091,    15133,
		15175,    15217,    15259,    15301,    15343,    15385,    15427,    15469,    15511,    15554,
		15596,    15638,    15680,    15722,    15764,    15806,    15849,    15891,    15933,    15975,
		16017,    16059,    16102,    16143,    16186,    16228,    16270,    16312,    16355,    16397,
		16439,    16482,    16524,    16566,    16608,    16651,    16693,    16735,    16778,    16820,
		16862,    16904,    16947,    16989,    17031,    17074,    17116,    17158,    17201,    17243,
		17285,    17328,    17370,    17413,    17455,    17497,    17540,    17582,    17624,    17667,
		17709,    17752,    17794,    17837,    17879,    17921,    17964,    18006,    18049,    18091,
		18134,    18176,    18218,    18261,    18303,    18346,    18388,    18431,    18473,    18516,
		18558,    18601,    18643,    18686,    18728,    18771,    18813,    18856,    18898,    18941,
		18983,    19026,    19068,    19111,    19154,    19196,    19239,    19281,    19324,    19366,
		19409,    19451,    19494,    19537,    19579,    19622,    19664,    19707,    19750,    19792,
		19835,    19877,    19920,    19962,    20005,    20048,    20090,    20133,    20175,    20218,
		20261,    20303,    20346,    20389,    20431,    20474,    20516,    20559,    20602,    20644,
		20687,    20730,    20772,    20815,    20857,    20900,    20943,    20985,    21028,    21071,
		21113,    21156,    21199,    21241,    21284,    21326,    21369,    21412,    21454,    21497,
		21540,    21582,    21625,    21668,    21710,    21753,    21796,    21838,    21881,    21924,
		21966,    22009,    22052,    22094,    22137,    22179,    22222,    22265,    22307,    22350,
		22393,    22435,    22478,    22521,    22563,    22606,    22649,    22691,    22734,    22776,
		22819,    22862,    22904,    22947,    22990,    23032,    23075,    23117,    23160,    23203,
		23245,    23288,    23331,    23373,    23416,    23458,    23501,    23544,    23586,    23629,
		23671,    23714,    23757,    23799,    23842,    23884,    23927,    23970,    24012,    24055,
		24097,    24140,    24182,    24225,    24267,    24310,    24353,    24395,    24438,    24480,
		24523,    24565,    24608,    24650,    24693,    24735,    24778,    24820,    24863,    24905,
		24948,    24990,    25033,    25075,    25118,    25160,    25203,    25245,    25288,    25330,
		25373,    25415,    25458,    25500,    25543,    25585,    25627,    25670,    25712,    25755,
		25797,    25840,    25882,    25924,    25967,    26009,    26052,    26094,    26136,    26179,
		26221,    26263,    26306,    26348,    26390,    26433,    26475,    26517,    26560,    26602,
		26644,    26687,    26729,    26771,    26814,    26856,    26898,    26940,    26983,    27025,
		27067,    27109,    27152,    27194,    27236,    27278,    27320,    27363,    27405,    27447,
		27489,    27531,    27574,    27616,    27658,    27700,    27742,    27784,    27826,    27869,
		27911,    27953,    27995,    28037,    28079,    28121,    28163,    28205,    28247,    28289,
		28332,    28374,    28416,    28458,    28500,    28542,    28584,    28626,    28668,    28710,
		28752,    28794,    28835,    28877,    28919,    28961,    29003,    29045,    29087,    29129,
		29171,    29213,    29255,    29297,    29338,    29380,    29422,    29464,    29506,    29548,
		29589,    29631,    29673,    29715,    29757,    29798,    29840,    29882,    29924,    29965,
		30007,    30049,    30090,    30132,    30174,    30216,    30257,    30299,    30341,    30382,
		30424,    30466,    30507,    30549,    30590,    30632,    30674,    30715,    30757,    30798,
		30840,    30881,    30923,    30964,    31006,    31047,    31089,    31130,    31172,    31213,
		31255,    31296,    31338,    31379,    31421,    31462,    31504,    31545,    31586,    31628,
		31669,    31710,    31752,    31793,    31834,    31876,    31917,    31958,    32000,    32040,
		32082,    32124,    32165,    32206,    32247,    32289,    32330,    32371,    32412,    32453,
		32494,    32536,    32577,    32618,    32659,    32700,    32741,    32783,    32824,    32865,
		32906,    32947,    32988,    33029,    33070,    33111,    33152,    33193,    33234,    33275,
		33316,    33357,    33398,    33439,    33480,    33521,    33562,    33603,    33644,    33685,
		33726,    33767,    33808,    33848,    33889,    33930,    33971,    34012,    34053,    34093,
		34134,    34175,    34216,    34257,    34297,    34338,    34379,    34420,    34460,    34501,
		34542,    34582,    34623,    34664,    34704,    34745,    34786,    34826,    34867,    34908,
		34948,    34989,    35029,    35070,    35110,    35151,    35192,    35232,    35273,    35313,
		35354,    35394,    35435,    35475,    35516,    35556,    35596,    35637,    35677,    35718,
		35758,    35798,    35839,    35879,    35920,    35960,    36000,    36041,    36081,    36121,
		36162,    36202,    36242,    36282,    36323,    36363,    36403,    36443,    36484,    36524,
		36564,    36604,    36644,    36685,    36725,    36765,    36805,    36845,    36885,    36925,
		36965,    37006,    37046,    37086,    37126,    37166,    37206,    37246,    37286,    37326,
		37366,    37406,    37446,    37486,    37526,    37566,    37606,    37646,    37686,    37725,
		37765,    37805,    37845,    37885,    37925,    37965,    38005,    38044,    38084,    38124,
		38164,    38204,    38243,    38283,    38323,    38363,    38402,    38442,    38482,    38522,
		38561,    38601,    38641,    38680,    38720,    38760,    38799,    38839,    38878,    38918,
		38958,    38997,    39037,    39076,    39116,    39155,    39195,    39235,    39274,    39314,
		39353,    39393,    39432,    39471,    39511,    39550,    39590,    39629,    39669,    39708,
		39747,    39787,    39826,    39866,    39905,    39944,    39984,    40023,    40062,    40101,
		40141,    40180,    40219,    40259,    40298,    40337,    40376,    40415,    40455,    40494,
		40533,    40572,    40611,    40651,    40690,    40729,    40768,    40807,    40846,    40885,
		40924,    40963,    41002,    41042,    41081,    41120,    41159,    41198,    41237,    41276,
		41315,    41354,    41393,    41431,    41470,    41509,    41548,    41587,    41626,    41665,
		41704,    41743,    41781,    41820,    41859,    41898,    41937,    41976,    42014,    42053,
		42092,    42131,    42169,    42208,    42247,    42286,    42324,    42363,    42402,    42440,
		42479,    42518,    42556,    42595,    42633,    42672,    42711,    42749,    42788,    42826,
		42865,    42903,    42942,    42980,    43019,    43057,    43096,    43134,    43173,    43211,
		43250,    43288,    43327,    43365,    43403,    43442,    43480,    43518,    43557,    43595,
		43633,    43672,    43710,    43748,    43787,    43825,    43863,    43901,    43940,    43978,
		44016,    44054,    44092,    44130,    44169,    44207,    44245,    44283,    44321,    44359,
		44397,    44435,    44473,    44512,    44550,    44588,    44626,    44664,    44702,    44740,
		44778,    44816,    44853,    44891,    44929,    44967,    45005,    45043,    45081,    45119,
		45157,    45194,    45232,    45270,    45308,    45346,    45383,    45421,    45459,    45497,
		45534,    45572,    45610,    45647,    45685,    45723,    45760,    45798,    45836,    45873,
		45911,    45948,    45986,    46024,    46061,    46099,    46136,    46174,    46211,    46249,
		46286,    46324,    46361,    46398,    46436,    46473,    46511,    46548,    46585,    46623,
		46660,    46697,    46735,    46772,    46809,    46847,    46884,    46921,    46958,    46995,
		47033,    47070,    47107,    47144,    47181,    47218,    47256,    47293,    47330,    47367,
		47404,    47441,    47478,    47515,    47552,    47589,    47626,    47663,    47700,    47737,
		47774,    47811,    47848,    47884,    47921,    47958,    47995,    48032,    48069,    48105,
		48142,    48179,    48216,    48252,    48289,    48326,    48363,    48399,    48436,    48473,
		48509,    48546,    48582,    48619,    48656,    48692,    48729,    48765,    48802,    48838,
		48875,    48911,    48948,    48984,    49021,    49057,    49093,    49130,    49166,    49202,
		49239,    49275,    49311,    49348,    49384,    49420,    49456,    49493,    49529,    49565,
		49601,    49637,    49674,    49710,    49746,    49782,    49818,    49854,    49890,    49926,
		49962,    49998,    50034,    50070,    50106,    50142,    50178,    50214,    50250,    50286,
		50322,    50358,    50393,    50429,    50465,    50501,    50537,    50572,    50608,    50644,
		50680,    50715,    50751,    50787,    50822,    50858,    50894,    50929,    50965,    51000,
		51036,    51071,    51107,    51142,    51178,    51213,    51249,    51284,    51320,    51355,
		51391,    51426,    51461,    51497,    51532,    51567,    51603,    51638,    51673,    51708,
		51744,    51779,    51814,    51849,    51885,    51920,    51955,    51990,    52025,    52060,
		52095,    52130,    52165,    52200,    52235,    52270,    52305,    52340,    52375,    52410,
		52445,    52480,    52515,    52550,    52585,    52620,    52654,    52689,    52724,    52759,
		52794,    52828,    52863,    52898,    52932,    52967,    53002,    53037,    53071,    53106,
		53140,    53175,    53210,    53244,    53279,    53313,    53348,    53382,    53417,    53451,
		53486,    53520,    53555,    53589,    53623,    53658,    53692,    53727,    53761,    53795,
		53830,    53864,    53898,    53932,    53967,    54001,    54035,    54069,    54104,    54138,
		54172,    54206,    54240,    54274,    54308,    54343,    54377,    54411,    54445,    54479,
		54513,    54547,    54581,    54615,    54649,    54683,    54717,    54751,    54785,    54819,
		54852,    54886,
	};
#endif

#ifdef TYPE_N_LUT
const int16_t Thermocouple_Type_N::lut_offset = -270;
const uint16_t Thermocouple_Type_N::lut_size = 1570;
const int32_t Thermocouple_Type_N::lut[1570] = {
	-4345,    -4345,    -4344,    -4344,    -4343,    -4342,    -4341,    -4340,    -4339,    -4337,
		-4336,    -4334,    -4332,    -4330,    -4328,    -4326,    -4324,    -4321,    -4319,    -4316,
		-4313,    -4310,    -4307,    -4304,    -4300,    -4297,    -4293,    -4289,    -4285,    -4281,
		-4277,    -4273,    -4268,    -4263,    -4258,    -4254,    -4248,    -4243,    -4238,    -4232,
		-4226,    -4221,    -4215,    -4209,    -4202,    -4196,    -4189,    -4183,    -4176,    -4169,
		-4162,    -4154,    -4147,    -4140,    -4132,    -4124,    -4116,    -4108,    -4100,    -4091,
		-4083,    -4074,    -4066,    -4057,    -4048,    -4038,    -4029,    -4019,    -4010,    -4000,
		-3990,    -3980,    -3970,    -3960,    -3950,    -3939,    -3928,    -3918,    -3907,    -3896,
		-3884,    -3873,    -3862,    -3850,    -3838,    -3827,    -3815,    -3803,    -3790,    -3778,
		-3766,    -3753,    -3740,    -3728,    -3715,    -3702,    -3688,    -3675,    -3662,    -3648,
		-3634,    -3621,    -3607,    -3593,    -3578,    -3564,    -3550,    -3535,    -3521,    -3506,
		-3491,    -3476,    -3461,    -3446,    -3431,    -3415,    -3400,    -3384,    -3368,    -3352,
		-3336,    -3320,    -3304,    -3288,    -3271,    -3255,    -3238,    -3221,    -3205,    -3188,
		-3171,    -3153,    -3136,    -3119,    -3101,    -3084,    -3066,    -3048,    -3030,    -3012,
		-2994,    -2976,    -2958,    -2939,    -2921,    -2902,    -2883,    -2865,    -2846,    -2827,
		-2808,    -2789,    -2769,    -2750,    -2730,    -2711,    -2691,    -2672,    -2652,    -2632,
		-2612,    -2592,    -2571,    -2551,    -2531,    -2510,    -2490,    -2469,    -2448,    -2428,
		-2407,    -2386,    -2365,    -2344,    -2322,    -2301,    -2280,    -2258,    -2237,    -2215,
		-2193,    -2172,    -2150,    -2128,    -2106,    -2084,    -2062,    -2039,    -2017,    -1995,
		-1972,    -1950,    -1927,    -1905,    -1882,    -1859,    -1836,    -1813,    -1790,    -1767,
		-1744,    -1721,    -1698,    -1674,    -1651,    -1627,    -1604,    -1580,    -1557,    -1533,
		-1509,    -1485,    -1462,    -1438,    -1414,    -1390,    -1366,    -1341,    -1317,    -1293,
		-1269,    -1244,    -1220,    -1195,    -1171,    -1146,    -1122,    -1097,    -1072,    -1048,
		-1022,     -998,     -973,     -948,     -923,     -898,     -873,     -848,     -823,     -798,
		-772,     -747,     -722,     -696,     -671,     -646,     -620,     -595,     -569,     -544,
		-518,     -492,     -467,     -441,     -415,     -390,     -364,     -338,     -312,     -286,
		-260,     -234,     -209,     -183,     -157,     -131,     -104,      -78,      -52,      -26,
		26,       52,       78,      104,      130,      156,      182,      208,      235,      261,
		287,      313,      340,      366,      393,      419,      446,      472,      499,      525,
		552,      578,      605,      632,      659,      685,      712,      739,      766,      793,
		820,      847,      874,      901,      928,      955,      983,     1010,     1037,     1065,
		1092,     1119,     1147,     1174,     1202,     1229,     1257,     1284,     1312,     1340,
		1368,     1395,     1423,     1451,     1479,     1507,     1535,     1563,     1591,     1619,
		1647,     1675,     1703,     1732,     1760,     1788,     1817,     1845,     1873,     1902,
		1930,     1959,     1988,     2016,     2045,     2074,     2102,     2131,     2160,     2189,
		2218,     2247,     2276,     2305,     2334,     2363,     2392,     2421,     2450,     2480,
		2509,     2538,     2568,     2597,     2626,     2656,     2685,     2715,     2744,     2774,
		2804,     2833,     2863,     2893,     2923,     2953,     2983,     3012,     3042,     3072,
		3102,     3133,     3163,     3193,     3223,     3253,     3283,     3314,     3344,     3374,
		3405,     3435,     3466,     3496,     3527,     3557,     3588,     3619,     3649,     3680,
		3711,     3742,     3772,     3803,     3834,     3865,     3896,     3927,     3958,     3989,
		4019,     4051,     4083,     4114,     4145,     4176,     4208,     4239,     4270,     4302,
		4333,     4365,     4396,     4428,     4459,     4491,     4523,     4554,     4586,     4618,
		4650,     4681,     4713,     4745,     4777,     4809,     4841,     4873,     4905,     4937,
		4969,     5001,     5033,     5066,     5098,     5130,     5162,     5195,     5227,     5259,
		5292,     5324,     5357,     5389,     5422,     5454,     5487,     5520,     5552,     5585,
		5618,     5650,     5683,     5716,     5749,     5782,     5815,     5847,     5880,     5913,
		5946,     5979,     6013,     6046,     6079,     6112,     6145,     6178,     6211,     6245,
		6278,     6311,     6345,     6378,     6411,     6445,     6478,     6512,     6545,     6579,
		6612,     6646,     6680,     6713,     6747,     6781,     6814,     6848,     6882,     6916,
		6949,     6983,     7017,     7051,     7085,     7119,     7153,     7187,     7221,     7255,
		7289,     7323,     7357,     7392,     7426,     7460,     7494,     7528,     7563,     7597,
		7631,     7666,     7700,     7734,     7769,     7803,     7838,     7872,     7907,     7941,
		7976,     8010,     8045,     8080,     8114,     8148,     8183,     8218,     8253,     8288,
		8323,     8358,     8392,     8427,     8462,     8497,     8532,     8567,     8602,     8637,
		8672,     8707,     8742,     8777,     8812,     8847,     8882,     8918,     8953,     8988,
		9023,     9058,     9094,     9129,     9164,     9200,     9235,     9270,     9306,     9341,
		9377,     9412,     9448,     9483,     9519,     9554,     9590,     9625,     9661,     9696,
		9732,     9768,     9803,     9839,     9875,     9910,     9946,     9982,    10018,    10054,
		10089,    10125,    10161,    10197,    10233,    10269,    10305,    10341,    10377,    10413,
		10449,    10485,    10521,    10557,    10593,    10629,    10665,    10701,    10737,    10774,
		10810,    10846,    10882,    10918,    10955,    10991,    11027,    11064,    11100,    11136,
		11173,    11209,    11245,    11282,    11318,    11355,    11391,    11428,    11464,    11501,
		11537,    11574,    11610,    11647,    11683,    11720,    11757,    11793,    11830,    11867,
		11903,    11940,    11977,    12013,    12050,    12087,    12124,    12160,    12197,    12234,
		12271,    12308,    12345,    12382,    12418,    12455,    12492,    12529,    12566,    12603,
		12640,    12677,    12714,    12751,    12788,    12825,    12862,    12899,    12937,    12974,
		13011,    13048,    13085,    13122,    13159,    13197,    13234,    13271,    13308,    13346,
		13383,    13420,    13457,    13495,    13532,    13569,    13607,    13644,    13682,    13719,
		13756,    13794,    13831,    13869,    13906,    13944,    13981,    14019,    14056,    14094,
		14131,    14169,    14206,    14244,    14281,    14319,    14356,    14394,    14432,    14469,
		14507,    14545,    14582,    14620,    14658,    14695,    14733,    14771,    14809,    14846,
		14884,    14922,    14960,    14998,    15035,    15073,    15111,    15149,    15187,    15225,
		15262,    15300,    15338,    15376,    15414,    15452,    15490,    15528,    15566,    15604,
		15642,    15680,    15718,    15756,    15794,    15832,    15870,    15908,    15946,    15984,
		16021,    16059,    16099,    16137,    16175,    16213,    16251,    16289,    16327,    16366,
		16404,    16442,    16480,    16518,    16557,    16595,    16633,    16671,    16710,    16748,
		16786,    16824,    16863,    16901,    16939,    16978,    17016,    17054,    17093,    17131,
		17169,    17208,    17246,    17285,    17323,    17361,    17400,    17438,    17477,    17515,
		17554,    17592,    17630,    17669,    17707,    17746,    17784,    17823,    17861,    17900,
		17938,    17977,    18016,    18054,    18093,    18131,    18170,    18208,    18247,    18286,
		18324,    18363,    18401,    18440,    18479,    18517,    18556,    18595,    18633,    18672,
		18711,    18749,    18788,    18827,    18865,    18904,    18943,    18982,    19020,    19059,
		19098,    19136,    19175,    19214,    19253,    19292,    19330,    19369,    19408,    19447,
		19485,    19524,    19563,    19602,    19641,    19680,    19718,    19757,    19796,    19835,
		19874,    19913,    19952,    19990,    20029,    20068,    20107,    20146,    20185,    20224,
		20263,    20302,    20341,    20379,    20418,    20457,    20496,    20535,    20574,    20613,
		20652,    20691,    20730,    20769,    20808,    20847,    20886,    20925,    20964,    21003,
		21042,    21081,    21120,    21159,    21198,    21237,    21276,    21315,    21354,    21393,
		21432,    21471,    21510,    21549,    21588,    21628,    21667,    21706,    21745,    21784,
		21823,    21862,    21901,    21940,    21979,    22018,    22058,    22097,    22136,    22175,
		22214,    22253,    22292,    22331,    22370,    22410,    22449,    22488,    22527,    22566,
		22605,    22644,    22684,    22723,    22762,    22801,    22840,    22879,    22919,    22958,
		22997,    23036,    23075,    23115,    23154,    23193,    23232,    23271,    23311,    23350,
		23389,    23428,    23467,    23507,    23546,    23585,    23624,    23663,    23703,    23742,
		23781,    23820,    23860,    23899,    23938,    23977,    24016,    24056,    24095,    24134,
		24173,    24213,    24252,    24291,    24330,    24370,    24409,    24448,    24487,    24527,
		24566,    24605,    24644,    24684,    24723,    24762,    24801,    24841,    24880,    24919,
		24959,    24998,    25037,    25076,    25116,    25155,    25194,    25233,    25273,    25312,
		25351,    25391,    25430,    25469,    25508,    25548,    25587,    25626,    25666,    25705,
		25744,    25783,    25823,    25862,    25901,    25941,    25980,    26019,    26058,    26098,
		26137,    26176,    26216,    26255,    26294,    26333,    26373,    26412,    26451,    26491,
		26530,    26569,    26608,    26648,    26687,    26726,    26766,    26805,    26844,    26883,
		26923,    26962,    27001,    27041,    27080,    27119,    27158,    27198,    27237,    27276,
		27316,    27355,    27394,    27433,    27473,    27512,    27551,    27591,    27630,    27669,
		27708,    27748,    27787,    27826,    27866,    27905,    27944,    27983,    28023,    28062,
		28101,    28140,    28180,    28219,    28258,    28297,    28337,    28376,    28415,    28455,
		28494,    28533,    28572,    28612,    28651,    28690,    28729,    28769,    28808,    28847,
		28886,    28926,    28965,    29004,    29043,    29083,    29122,    29161,    29200,    29239,
		29279,    29318,    29357,    29396,    29436,    29475,    29514,    29553,    29592,    29632,
		29671,    29710,    29749,    29789,    29828,    29867,    29906,    29945,    29985,    30024,
		30063,    30102,    30141,    30181,    30220,    30259,    30298,    30337,    30376,    30416,
		30455,    30494,    30533,    30572,    30611,    30651,    30690,    30729,    30768,    30807,
		30846,    30886,    30925,    30964,    31003,    31042,    31081,    31120,    31160,    31199,
		31238,    31277,    31316,    31355,    31394,    31433,    31473,    31512,    31551,    31590,
		31629,    31668,    31707,    31746,    31785,    31824,    31863,    31903,    31942,    31981,
		32020,    32058,    32098,    32137,    32176,    32215,    32253,    32293,    32332,    32371,
		32409,    32448,    32488,    32527,    32566,    32604,    32644,    32683,    32722,    32761,
		32800,    32839,    32878,    32917,    32956,    32995,    33034,    33073,    33112,    33151,
		33190,    33229,    33268,    33307,    33346,    33385,    33424,    33463,    33502,    33541,
		33580,    33619,    33658,    33697,    33736,    33774,    33813,    33852,    33891,    33930,
		33969,    34008,    34047,    34086,    34124,    34163,    34202,    34241,    34280,    34319,
		34358,    34396,    34435,    34474,    34513,    34552,    34591,    34629,    34668,    34707,
		34746,    34785,    34823,    34862,    34901,    34940,    34979,    35017,    35056,    35095,
		35134,    35172,    35211,    35250,    35289,    35327,    35366,    35405,    35444,    35482,
		35521,    35560,    35598,    35637,    35676,    35714,    35753,    35792,    35831,    35869,
		35908,    35946,    35985,    36024,    36062,    36101,    36140,    36178,    36217,    36256,
		36294,    36333,    36371,    36410,    36449,    36487,    36526,    36564,    36603,    36641,
		36680,    36718,    36757,    36796,    36834,    36873,    36911,    36950,    36988,    37027,
		37065,    37104,    37142,    37181,    37219,    37258,    37296,    37334,    37373,    37411,
		37450,    37488,    37527,    37565,    37603,    37642,    37680,    37719,    37757,    37795,
		37834,    37872,    37911,    37949,    37987,    38026,    38064,    38102,    38141,    38179,
		38217,    38256,    38294,    38332,    38370,    38409,    38447,    38485,    38524,    38562,
		38600,    38638,    38677,    38715,    38753,    38791,    38829,    38868,    38906,    38944,
		38982,    39020,    39059,    39097,    39135,    39173,    39211,    39249,    39287,    39326,
		39364,    39402,    39440,    39478,    39516,    39554,    39592,    39630,    39668,    39706,
		39744,    39783,    39821,    39859,    39897,    39935,    39973,    40011,    40049,    40087,
		40125,    40163,    40201,    40238,    40276,    40314,    40352,    40390,    40428,    40466,
		40504,    40542,    40580,    40618,    40655,    40693,    40731,    40769,    40807,    40845,
		40883,    40920,    40958,    40996,    41034,    41072,    41109,    41147,    41185,    41223,
		41260,    41298,    41336,    41374,    41411,    41449,    41487,    41525,    41562,    41600,
		41638,    41675,    41713,    41751,    41788,    41826,    41864,    41901,    41939,    41976,
		42014,    42052,    42089,    42127,    42164,    42202,    42239,    42277,    42314,    42352,
		42390,    42427,    42465,    42502,    42540,    42577,    42614,    42652,    42689,    42727,
		42764,    42802,    42839,    42877,    42914,    42951,    42989,    43026,    43064,    43101,
		43138,    43176,    43213,    43250,    43288,    43325,    43362,    43399,    43437,    43474,
		43511,    43549,    43586,    43623,    43660,    43698,    43735,    43772,    43809,    43846,
		43884,    43921,    43958,    43995,    44032,    44069,    44106,    44144,    44181,    44218,
		44255,    44292,    44329,    44366,    44403,    44440,    44477,    44514,    44551,    44588,
		44625,    44662,    44699,    44736,    44773,    44810,    44847,    44884,    44921,    44958,
		44995,    45032,    45069,    45105,    45142,    45179,    45216,    45253,    45290,    45326,
		45363,    45400,    45437,    45474,    45510,    45547,    45584,    45621,    45657,    45694,
		45731,    45767,    45804,    45841,    45877,    45914,    45951,    45987,    46024,    46060,
		46097,    46133,    46170,    46207,    46243,    46280,    46316,    46353,    46389,    46425,
		46462,    46498,    46535,    46571,    46608,    46644,    46680,    46717,    46753,    46789,
		46826,    46862,    46898,    46935,    46971,    47007,    47043,    47079,    47116,    47152,
		47188,    47224,    47260,    47296,    47333,    47369,    47405,    47441,    47477,    47513,
	};
#endif

#ifdef TYPE_R_LUT
const int16_t Thermocouple_Type_R::lut_offset = -50;
const uint16_t Thermocouple_Type_R::lut_size = 1818;
const int32_t Thermocouple_Type_R::lut[1818] = {
	-226,     -223,     -219,     -215,     -211,     -208,     -204,     -200,     -196,     -192,
		-188,     -184,     -180,     -175,     -171,     -167,     -163,     -158,     -154,     -150,
		-145,     -141,     -137,     -132,     -128,     -123,     -119,     -114,     -109,     -105,
		-100,      -95,      -91,      -86,      -81,      -76,      -71,      -66,      -61,      -56,
		-51,      -46,      -41,      -36,      -31,      -26,      -21,      -16,      -11,       -5,
		5,       11,       16,       21,       27,       32,       38,       43,       49,       54,
		60,       65,       71,       77,       82,       88,       94,      100,      105,      111,
		117,      123,      129,      135,      141,      147,      153,      159,      165,      171,
		177,      183,      189,      195,      201,      207,      214,      220,      226,      232,
		239,      245,      251,      258,      264,      271,      277,      284,      290,      296,
		303,      310,      316,      323,      329,      336,      343,      349,      356,      363,
		369,      376,      383,      390,      397,      403,      410,      417,      424,      431,
		438,      445,      452,      459,      466,      473,      480,      487,      494,      501,
		508,      516,      523,      530,      537,      544,      552,      559,      566,      573,
		581,      588,      595,      603,      610,      618,      625,      632,      640,      647,
		655,      662,      670,      677,      685,      693,      700,      708,      715,      723,
		731,      738,      746,      754,      761,      769,      777,      785,      792,      800,
		808,      816,      824,      832,      839,      847,      855,      863,      871,      879,
		887,      895,      903,      911,      919,      927,      935,      943,      951,      959,
		967,      976,      984,      992,     1000,     1008,     1016,     1025,     1033,     1041,
		1049,     1058,     1066,     1074,     1082,     1091,     1099,     1107,     1116,     1124,
		1132,     1141,     1149,     1158,     1166,     1175,     1183,     1191,     1200,     1208,
		1217,     1225,     1234,     1242,     1251,     1260,     1268,     1277,     1285,     1294,
		1303,     1311,     1320,     1329,     1337,     1346,     1355,     1363,     1372,     1381,
		1389,     1398,     1407,     1416,     1425,     1433,     1442,     1451,     1460,     1469,
		1477,     1486,     1495,     1504,     1513,     1522,     1531,     1540,     1549,     1558,
		1567,     1575,     1584,     1593,     1602,     1611,     1620,     1629,     1639,     1648,
		1657,     1666,     1675,     1684,     1693,     1702,     1711,     1720,     1729,     1739,
		1748,     1757,     1766,     1775,     1784,     1794,     1803,     1812,     1821,     1831,
		1840,     1849,     1858,     1868,     1877,     1886,     1895,     1905,     1914,     1923,
		1933,     1942,     1951,     1961,     1970,     1980,     1989,     1998,     2008,     2017,
		2027,     2036,     2045,     2055,     2064,     2074,     2083,     2093,     2102,     2112,
		2121,     2131,     2140,     2150,     2159,     2169,     2179,     2188,     2198,     2207,
		2217,     2226,     2236,     2246,     2255,     2265,     2275,     2284,     2294,     2304,
		2313,     2323,     2333,     2342,     2352,     2362,     2371,     2381,     2391,     2401,
		2410,     2420,     2430,     2440,     2449,     2459,     2469,     2479,     2488,     2498,
		2508,     2518,     2528,     2538,     2547,     2557,     2567,     2577,     2587,     2597,
		2607,     2617,     2626,     2636,     2646,     2656,     2666,     2676,     2686,     2696,
		2706,     2716,     2726,     2736,     2746,     2756,     2766,     2776,     2786,     2796,
		2806,     2816,     2826,     2836,     2846,     2856,     2866,     2876,     2886,     2896,
		2906,     2916,     2926,     2937,     2947,     2957,     2967,     2977,     2987,     2997,
		3007,     3018,     3028,     3038,     3048,     3058,     3068,     3079,     3089,     3099,
		3109,     3119,     3130,     3140,     3150,     3160,     3171,     3181,     3191,     3201,
		3212,     3222,     3232,     3242,     3253,     3263,     3273,     3284,     3294,     3304,
		3315,     3325,     3335,     3346,     3356,     3366,     3377,     3387,     3397,     3408,
		3418,     3428,     3439,     3449,     3460,     3470,     3480,     3491,     3501,     3512,
		3522,     3533,     3543,     3553,     3564,     3574,     3585,     3595,     3606,     3616,
		3627,     3637,     3648,     3658,     3669,     3679,     3690,     3700,     3711,     3721,
		3732,     3742,     3753,     3764,     3774,     3785,     3795,     3806,     3816,     3827,
		3838,     3848,     3859,     3869,     3880,     3891,     3901,     3912,     3922,     3933,
		3944,     3954,     3965,     3976,     3986,     3997,     4008,     4018,     4029,     4040,
		4050,     4061,     4072,     4083,     4093,     4104,     4115,     4125,     4136,     4147,
		4158,     4168,     4179,     4190,     4201,     4211,     4222,     4233,     4244,     4255,
		4265,     4276,     4287,     4298,     4309,     4319,     4330,     4341,     4352,     4363,
		4373,     4384,     4395,     4406,     4417,     4428,     4439,     4449,     4460,     4471,
		4482,     4493,     4504,     4515,     4526,     4537,     4548,     4558,     4569,     4580,
		4591,     4602,     4613,     4624,     4635,     4646,     4657,     4668,     4679,     4690,
		4701,     4712,     4723,     4734,     4745,     4756,     4767,     4778,     4789,     4800,
		4811,     4822,     4833,     4844,     4855,     4866,     4877,     4888,     4899,     4910,
		4922,     4933,     4944,     4955,     4966,     4977,     4988,     4999,     5010,     5021,
		5033,     5044,     5055,     5066,     5077,     5088,     5099,     5111,     5122,     5133,
		5144,     5155,     5166,     5178,     5189,     5200,     5211,     5222,     5234,     5245,
		5256,     5267,     5279,     5290,     5301,     5312,     5323,     5335,     5346,     5357,
		5369,     5380,     5391,     5402,     5414,     5425,     5436,     5448,     5459,     5470,
		5481,     5493,     5504,     5515,     5527,     5538,     5549,     5561,     5572,     5583,
		5595,     5606,     5618,     5629,     5640,     5652,     5663,     5674,     5686,     5697,
		5709,     5720,     5731,     5743,     5754,     5766,     5777,     5789,     5800,     5812,
		5823,     5834,     5846,     5857,     5869,     5880,     5892,     5903,     5915,     5926,
		5938,     5949,     5961,     5972,     5984,     5995,     6007,     6018,     6030,     6041,
		6053,     6065,     6076,     6088,     6099,     6111,     6122,     6134,     6146,     6157,
		6169,     6180,     6192,     6204,     6215,     6227,     6238,     6250,     6262,     6273,
		6285,     6297,     6308,     6320,     6332,     6343,     6355,     6367,     6378,     6390,
		6402,     6413,     6425,     6437,     6448,     6460,     6472,     6484,     6495,     6507,
		6519,     6531,     6542,     6554,     6566,     6578,     6589,     6601,     6613,     6625,
		6636,     6648,     6660,     6672,     6684,     6695,     6707,     6719,     6731,     6743,
		6755,     6766,     6778,     6790,     6802,     6814,     6826,     6838,     6849,     6861,
		6873,     6885,     6897,     6909,     6921,     6933,     6945,     6956,     6968,     6980,
		6992,     7004,     7016,     7028,     7040,     7052,     7064,     7076,     7088,     7100,
		7112,     7124,     7136,     7148,     7160,     7172,     7184,     7196,     7208,     7220,
		7232,     7244,     7256,     7268,     7280,     7292,     7304,     7316,     7328,     7340,
		7352,     7364,     7376,     7389,     7401,     7413,     7425,     7437,     7449,     7461,
		7473,     7485,     7498,     7510,     7522,     7534,     7546,     7558,     7570,     7583,
		7595,     7607,     7619,     7631,     7644,     7656,     7668,     7680,     7692,     7705,
		7717,     7729,     7741,     7753,     7766,     7778,     7790,     7802,     7815,     7827,
		7839,     7851,     7864,     7876,     7888,     7901,     7913,     7925,     7938,     7950,
		7962,     7974,     7987,     7999,     8010,     8023,     8036,     8048,     8061,     8073,
		8086,     8098,     8109,     8122,     8135,     8147,     8160,     8172,     8185,     8197,
		8209,     8222,     8234,     8247,     8259,     8272,     8284,     8296,     8309,     8321,
		8334,     8346,     8359,     8371,     8384,     8396,     8409,     8421,     8434,     8446,
		8459,     8471,     8484,     8496,     8509,     8521,     8534,     8546,     8559,     8571,
		8584,     8597,     8609,     8622,     8634,     8647,     8659,     8672,     8685,     8697,
		8710,     8722,     8735,     8748,     8760,     8773,     8785,     8798,     8811,     8823,
		8836,     8849,     8861,     8874,     8887,     8899,     8912,     8925,     8937,     8950,
		8963,     8975,     8988,     9001,     9014,     9026,     9039,     9052,     9065,     9077,
		9090,     9103,     9115,     9128,     9141,     9154,     9167,     9179,     9192,     9205,
		9218,     9230,     9243,     9256,     9269,     9282,     9294,     9307,     9320,     9333,
		9346,     9359,     9371,     9384,     9397,     9410,     9423,     9436,     9449,     9461,
		9474,     9487,     9500,     9513,     9526,     9539,     9552,     9565,     9578,     9590,
		9603,     9616,     9629,     9642,     9655,     9668,     9681,     9694,     9707,     9720,
		9733,     9746,     9759,     9772,     9785,     9798,     9811,     9824,     9837,     9850,
		9863,     9876,     9889,     9902,     9915,     9928,     9941,     9954,     9967,     9980,
		9993,    10006,    10019,    10032,    10046,    10059,    10072,    10085,    10098,    10111,
		10124,    10137,    10150,    10163,    10177,    10190,    10203,    10216,    10229,    10242,
		10255,    10268,    10282,    10295,    10308,    10321,    10334,    10347,    10361,    10374,
		10387,    10400,    10413,    10427,    10440,    10453,    10466,    10480,    10493,    10506,
		10519,    10532,    10546,    10559,    10572,    10585,    10599,    10612,    10625,    10638,
		10652,    10665,    10678,    10692,    10705,    10718,    10731,    10745,    10758,    10771,
		10785,    10798,    10811,    10825,    10838,    10851,    10865,    10878,    10891,    10905,
		10918,    10932,    10945,    10958,    10972,    10985,    10998,    11012,    11025,    11039,
		11052,    11065,    11079,    11092,    11106,    11119,    11132,    11146,    11159,    11173,
		11186,    11200,    11213,    11227,    11240,    11253,    11267,    11280,    11294,    11307,
		11321,    11334,    11348,    11361,    11375,    11388,    11402,    11415,    11429,    11442,
		11456,    11469,    11483,    11496,    11510,    11524,    11537,    11551,    11564,    11578,
		11591,    11605,    11618,    11632,    11646,    11659,    11673,    11686,    11700,    11714,
		11727,    11741,    11754,    11768,    11782,    11795,    11809,    11822,    11836,    11850,
		11863,    11877,    11891,    11904,    11918,    11931,    11945,    11959,    11972,    11986,
		12000,    12013,    12027,    12041,    12054,    12068,    12082,    12096,    12109,    12123,
		12137,    12150,    12164,    12178,    12191,    12205,    12219,    12233,    12246,    12260,
		12274,    12288,    12301,    12315,    12329,    12342,    12356,    12370,    12384,    12397,
		12411,    12425,    12439,    12453,    12466,    12480,    12494,    12508,    12521,    12535,
		12549,    12563,    12577,    12590,    12604,    12618,    12632,    12646,    12659,    12673,
		12687,    12701,    12715,    12729,    12742,    12756,    12770,    12784,    12798,    12812,
		12825,    12839,    12853,    12867,    12881,    12895,    12909,    12922,    12936,    12950,
		12964,    12978,    12992,    13006,    13019,    13033,    13047,    13061,    13075,    13089,
		13103,    13117,    13131,    13145,    13158,    13172,    13186,    13200,    13214,    13228,
		13242,    13256,    13270,    13284,    13298,    13311,    13325,    13339,    13353,    13367,
		13381,    13395,    13409,    13423,    13437,    13451,    13465,    13479,    13493,    13507,
		13521,    13535,    13549,    13563,    13577,    13590,    13604,    13618,    13632,    13646,
		13660,    13674,    13688,    13702,    13716,    13730,    13744,    13758,    13772,    13786,
		13800,    13814,    13828,    13842,    13856,    13870,    13884,    13898,    13912,    13926,
		13940,    13954,    13968,    13982,    13996,    14010,    14024,    14038,    14052,    14066,
		14081,    14095,    14109,    14123,    14137,    14151,    14165,    14179,    14193,    14207,
		14221,    14235,    14249,    14263,    14277,    14291,    14305,    14319,    14333,    14347,
		14361,    14375,    14390,    14404,    14418,    14432,    14446,    14460,    14474,    14488,
		14502,    14516,    14530,    14544,    14558,    14572,    14586,    14601,    14615,    14629,
		14643,    14657,    14671,    14685,    14699,    14713,    14727,    14741,    14755,    14770,
		14784,    14798,    14812,    14826,    14840,    14854,    14868,    14882,    14896,    14911,
		14925,    14939,    14953,    14967,    14981,    14995,    15009,    15023,    15037,    15052,
		15066,    15080,    15094,    15108,    15122,    15136,    15150,    15164,    15179,    15193,
		15207,    15221,    15235,    15249,    15263,    15277,    15291,    15306,    15320,    15334,
		15348,    15362,    15376,    15390,    15404,    15419,    15433,    15447,    15461,    15475,
		15489,    15503,    15517,    15531,    15546,    15560,    15574,    15588,    15602,    15616,
		15630,    15645,    15659,    15673,    15687,    15701,    15715,    15729,    15743,    15758,
		15772,    15786,    15800,    15814,    15828,    15842,    15856,    15871,    15885,    15899,
		15913,    15927,    15941,    15955,    15969,    15984,    15998,    16012,    16026,    16040,
		16053,    16068,    16082,    16097,    16111,    16125,    16139,    16152,    16167,    16181,
		16196,    16210,    16224,    16238,    16251,    16265,    16280,    16294,    16309,    16323,
		16337,    16351,    16364,    16379,    16393,    16407,    16422,    16436,    16450,    16464,
		16478,    16492,    16506,    16520,    16534,    16549,    16563,    16577,    16591,    16605,
		16619,    16633,    16647,    16662,    16676,    16690,    16704,    16718,    16732,    16746,
		16760,    16774,    16789,    16803,    16817,    16831,    16845,    16859,    16873,    16887,
		16901,    16915,    16930,    16944,    16958,    16972,    16986,    17000,    17014,    17028,
		17042,    17056,    17071,    17085,    17099,    17113,    17127,    17141,    17155,    17169,
		17183,    17197,    17211,    17225,    17240,    17254,    17268,    17282,    17296,    17310,
		17324,    17338,    17352,    17366,    17380,    17394,    17408,    17423,    17437,    17451,
		17465,    17479,    17493,    17507,    17521,    17535,    17549,    17563,    17577,    17591,
		17605,    17619,    17633,    17647,    17661,    17676,    17690,    17704,    17718,    17732,
		17746,    17760,    17774,    17788,    17802,    17816,    17830,    17844,    17858,    17872,
		17886,    17900,    17914,    17928,    17942,    17956,    17970,    17984,    17998,    18012,
		18026,    18040,    18054,    18068,    18082,    18096,    18110,    18124,    18138,    18152,
		18166,    18180,    18194,    18208,    18222,    18236,    18250,    18264,    18278,    18292,
		18306,    18320,    18334,    18348,    18362,    18376,    18390,    18404,    18417,    18431,
		18445,    18459,    18473,    18487,    18501,    18515,    18529,    18543,    18557,    18571,
		18585,    18599,    18613,    18627,    18640,    18654,    18668,    18682,    18696,    18710,
		18724,    18738,    18752,    18766,    18779,    18793,    18807,    18821,    18835,    18849,
		18863,    18877,    18891,    18904,    18918,    18932,    18946,    18960,    18974,    18988,
		19002,    19015,    19029,    19043,    19057,    19071,    19085,    19098,    19112,    19126,
		19140,    19154,    19168,    19181,    19195,    19209,    19223,    19237,    19250,    19264,
		19278,    19292,    19306,    19319,    19333,    19347,    19361,    19375,    19388,    19402,
		19416,    19430,    19444,    19457,    19471,    19485,    19499,    19512,    19526,    19540,
		19554,    19567,    19581,    19595,    19609,    19622,    19636,    19650,    19663,    19677,
		19691,    19705,    19718,    19732,    19746,    19759,    19773,    19787,    19800,    19814,
		19828,    19841,    19855,    19869,    19882,    19896,    19910,    19923,    19937,    19951,
		19964,    19978,    19992,    20005,    20019,    20032,    20046,    20060,    20073,    20087,
		20100,    20114,    20127,    20141,    20154,    20168,    20181,    20195,    20208,    20222,
		20235,    20249,    20262,    20275,    20289,    20302,    20316,    20329,    20342,    20356,
		20369,    20382,    20396,    20409,    20422,    20436,    20449,    20462,    20475,    20488,
		20502,    20515,    20528,    20541,    20554,    20567,    20581,    20594,    20607,    20620,
		20633,    20646,    20659,    20672,    20685,    20698,    20711,    20724,    20736,    20749,
		20762,    20775,    20788,    20801,    20813,    20826,    20839,    20852,    20864,    20877,
		20890,    20902,    20915,    20928,    20940,    20953,    20965,    20978,    20990,    21003,
		21015,    21027,    21040,    21052,    21065,    21077,    21089,    21101,
	};
#endif

#ifdef TYPE_S_LUT
const int16_t Thermocouple_Type_S::lut_offset = -50;
const uint16_t Thermocouple_Type_S::lut_size = 1818;
const int32_t Thermocouple_Type_S::lut[1818] = {
	-236,     -232,     -228,     -224,     -219,     -215,     -211,     -207,     -203,     -199,
		-194,     -190,     -186,     -181,     -177,     -173,     -168,     -164,     -159,     -155,
		-150,     -146,     -141,     -136,     -132,     -127,     -122,     -117,     -113,     -108,
		-103,      -98,      -93,      -88,      -83,      -78,      -73,      -68,      -63,      -58,
		-53,      -48,      -42,      -37,      -32,      -27,      -21,      -16,      -11,       -5,
		5,       11,       16,       22,       27,       33,       38,       44,       50,       55,
		61,       67,       72,       78,       84,       90,       95,      101,      107,      113,
		119,      125,      131,      137,      143,      149,      155,      161,      167,      173,
		179,      185,      191,      197,      204,      210,      216,      222,      229,      235,
		241,      248,      254,      260,      267,      273,      280,      286,      292,      299,
		305,      312,      319,      325,      332,      338,      345,      352,      358,      365,
		372,      378,      385,      392,      399,      405,      412,      419,      426,      433,
		440,      446,      453,      460,      467,      474,      481,      488,      495,      502,
		509,      516,      523,      530,      538,      545,      552,      559,      566,      573,
		580,      588,      595,      602,      609,      617,      624,      631,      639,      646,
		653,      661,      668,      675,      683,      690,      698,      705,      713,      720,
		727,      735,      743,      750,      758,      765,      773,      780,      788,      795,
		803,      811,      818,      826,      834,      841,      849,      857,      865,      872,
		880,      888,      896,      903,      911,      919,      927,      935,      942,      950,
		958,      966,      974,      982,      990,      998,     1006,     1012,     1020,     1029,
		1037,     1045,     1053,     1061,     1069,     1077,     1085,     1094,     1102,     1110,
		1118,     1126,     1134,     1142,     1150,     1158,     1167,     1175,     1183,     1191,
		1199,     1207,     1216,     1224,     1232,     1240,     1249,     1257,     1265,     1273,
		1282,     1290,     1298,     1307,     1315,     1323,     1332,     1340,     1348,     1357,
		1365,     1373,     1382,     1390,     1399,     1407,     1415,     1424,     1432,     1441,
		1449,     1458,     1466,     1475,     1483,     1492,     1500,     1509,     1517,     1526,
		1534,     1543,     1551,     1560,     1569,     1577,     1586,     1594,     1603,     1612,
		1620,     1629,     1638,     1646,     1655,     1663,     1672,     1681,     1690,     1698,
		1707,     1716,     1724,     1733,     1742,     1751,     1759,     1768,     1777,     1786,
		1794,     1803,     1812,     1821,     1829,     1838,     1847,     1856,     1865,     1874,
		1882,     1891,     1900,     1909,     1918,     1927,     1936,     1944,     1953,     1962,
		1971,     1980,     1989,     1998,     2007,     2016,     2025,     2033,     2043,     2052,
		2061,     2070,     2078,     2087,     2096,     2105,     2114,     2123,     2132,     2141,
		2151,     2160,     2169,     2178,     2187,     2196,     2205,     2214,     2223,     2232,
		2241,     2250,     2259,     2268,     2277,     2287,     2296,     2305,     2314,     2323,
		2332,     2341,     2350,     2360,     2369,     2378,     2387,     2396,     2405,     2415,
		2424,     2433,     2442,     2451,     2461,     2470,     2479,     2488,     2497,     2507,
		2516,     2525,     2534,     2544,     2553,     2562,     2571,     2581,     2590,     2599,
		2609,     2618,     2627,     2636,     2646,     2655,     2664,     2674,     2683,     2692,
		2702,     2711,     2720,     2730,     2739,     2748,     2758,     2767,     2776,     2786,
		2795,     2805,     2814,     2823,     2833,     2842,     2851,     2861,     2870,     2880,
		2889,     2899,     2908,     2917,     2927,     2936,     2946,     2955,     2965,     2974,
		2983,     2993,     3002,     3012,     3021,     3031,     3040,     3050,     3059,     3069,
		3078,     3088,     3097,     3107,     3116,     3126,     3135,     3145,     3154,     3164,
		3173,     3183,     3192,     3202,     3212,     3221,     3231,     3240,     3250,     3259,
		3269,     3279,     3288,     3298,     3307,     3317,     3326,     3336,     3346,     3355,
		3365,     3374,     3384,     3394,     3403,     3413,     3423,     3432,     3442,     3451,
		3461,     3471,     3480,     3490,     3500,     3509,     3519,     3529,     3538,     3548,
		3558,     3567,     3577,     3587,     3596,     3606,     3616,     3626,     3635,     3645,
		3655,     3664,     3674,     3684,     3694,     3703,     3713,     3723,     3732,     3742,
		3752,     3762,     3771,     3781,     3791,     3801,     3810,     3820,     3830,     3840,
		3850,     3859,     3869,     3879,     3889,     3898,     3908,     3918,     3928,     3938,
		3947,     3957,     3967,     3977,     3987,     3997,     4006,     4016,     4026,     4035,
		4046,     4056,     4065,     4075,     4085,     4094,     4105,     4115,     4125,     4134,
		4144,     4154,     4164,     4174,     4184,     4194,     4204,     4213,     4223,     4233,
		4243,     4253,     4263,     4273,     4283,     4293,     4303,     4313,     4323,     4332,
		4342,     4352,     4362,     4372,     4382,     4392,     4402,     4412,     4422,     4432,
		4442,     4452,     4462,     4472,     4482,     4492,     4502,     4512,     4522,     4532,
		4542,     4552,     4562,     4572,     4582,     4592,     4602,     4612,     4622,     4632,
		4642,     4652,     4662,     4672,     4682,     4692,     4702,     4712,     4722,     4732,
		4742,     4752,     4762,     4772,     4782,     4793,     4803,     4813,     4823,     4833,
		4843,     4853,     4863,     4873,     4883,     4893,     4904,     4914,     4924,     4934,
		4944,     4954,     4964,     4974,     4984,     4995,     5005,     5015,     5025,     5035,
		5045,     5055,     5066,     5076,     5086,     5096,     5106,     5116,     5127,     5137,
		5147,     5157,     5167,     5178,     5188,     5198,     5208,     5218,     5228,     5239,
		5249,     5259,     5269,     5280,     5290,     5300,     5310,     5320,     5331,     5341,
		5351,     5361,     5372,     5382,     5392,     5402,     5413,     5423,     5433,     5443,
		5454,     5464,     5474,     5485,     5495,     5505,     5515,     5526,     5536,     5546,
		5557,     5567,     5577,     5588,     5598,     5608,     5618,     5629,     5639,     5649,
		5660,     5670,     5680,     5691,     5701,     5712,     5722,     5732,     5743,     5753,
		5763,     5774,     5784,     5794,     5805,     5815,     5826,     5836,     5846,     5857,
		5867,     5878,     5888,     5898,     5909,     5919,     5930,     5940,     5950,     5961,
		5971,     5982,     5992,     6003,     6013,     6024,     6034,     6044,     6055,     6065,
		6076,     6086,     6097,     6107,     6118,     6128,     6139,     6149,     6160,     6170,
		6181,     6191,     6202,     6212,     6223,     6233,     6244,     6254,     6265,     6275,
		6286,     6296,     6307,     6317,     6328,     6338,     6349,     6360,     6370,     6381,
		6391,     6402,     6412,     6423,     6434,     6444,     6455,     6465,     6476,     6486,
		6497,     6508,     6518,     6529,     6539,     6550,     6561,     6571,     6582,     6593,
		6603,     6614,     6624,     6635,     6646,     6656,     6667,     6678,     6688,     6699,
		6710,     6720,     6731,     6742,     6752,     6763,     6774,     6784,     6795,     6806,
		6817,     6827,     6838,     6849,     6859,     6870,     6881,     6892,     6902,     6913,
		6924,     6934,     6945,     6956,     6967,     6977,     6988,     6999,     7010,     7020,
		7031,     7042,     7053,     7064,     7074,     7085,     7096,     7107,     7117,     7128,
		7139,     7150,     7161,     7172,     7182,     7193,     7204,     7215,     7226,     7236,
		7247,     7258,     7269,     7280,     7291,     7302,     7312,     7323,     7334,     7345,
		7356,     7367,     7378,     7388,     7399,     7410,     7421,     7432,     7443,     7454,
		7465,     7476,     7487,     7497,     7508,     7519,     7530,     7541,     7552,     7563,
		7574,     7585,     7596,     7607,     7618,     7629,     7640,     7651,     7662,     7673,
		7684,     7695,     7706,     7717,     7728,     7739,     7750,     7761,     7772,     7783,
		7794,     7805,     7816,     7827,     7838,     7849,     7860,     7871,     7882,     7893,
		7904,     7915,     7926,     7937,     7948,     7959,     7970,     7981,     7992,     8003,
		8013,     8026,     8037,     8048,     8058,     8070,     8080,     8092,     8103,     8114,
		8125,     8137,     8148,     8159,     8170,     8180,     8192,     8203,     8214,     8226,
		8237,     8248,     8259,     8270,     8281,     8293,     8304,     8315,     8326,     8337,
		8348,     8360,     8371,     8382,     8393,     8404,     8416,     8427,     8438,     8449,
		8460,     8472,     8483,     8494,     8505,     8517,     8528,     8539,     8550,     8562,
		8573,     8584,     8595,     8607,     8618,     8629,     8640,     8652,     8663,     8674,
		8685,     8697,     8708,     8719,     8731,     8742,     8753,     8765,     8776,     8787,
		8798,     8810,     8821,     8832,     8844,     8855,     8866,     8878,     8889,     8900,
		8912,     8923,     8935,     8946,     8957,     8969,     8980,     8991,     9003,     9014,
		9025,     9037,     9048,     9060,     9071,     9082,     9094,     9105,     9117,     9128,
		9139,     9151,     9162,     9174,     9185,     9197,     9208,     9219,     9231,     9242,
		9254,     9265,     9277,     9288,     9300,     9311,     9323,     9334,     9345,     9357,
		9368,     9380,     9391,     9403,     9414,     9426,     9437,     9449,     9460,     9472,
		9483,     9495,     9506,     9518,     9529,     9541,     9552,     9564,     9576,     9587,
		9599,     9610,     9622,     9633,     9645,     9656,     9668,     9680,     9691,     9703,
		9714,     9726,     9737,     9749,     9761,     9772,     9784,     9795,     9807,     9819,
		9830,     9842,     9853,     9865,     9877,     9888,     9900,     9911,     9923,     9935,
		9946,     9958,     9970,     9981,     9993,    10005,    10016,    10028,    10040,    10051,
		10063,    10075,    10086,    10098,    10110,    10121,    10133,    10145,    10156,    10168,
		10180,    10191,    10203,    10215,    10227,    10238,    10250,    10262,    10273,    10285,
		10297,    10309,    10320,    10332,    10344,    10356,    10367,    10379,    10391,    10403,
		10414,    10426,    10438,    10450,    10461,    10473,    10485,    10497,    10509,    10520,
		10532,    10544,    10556,    10567,    10579,    10591,    10603,    10615,    10626,    10638,
		10650,    10662,    10674,    10686,    10697,    10709,    10721,    10733,    10745,    10757,
		10768,    10780,    10792,    10804,    10816,    10828,    10839,    10851,    10863,    10875,
		10887,    10899,    10911,    10922,    10934,    10946,    10958,    10970,    10982,    10994,
		11006,    11017,    11029,    11041,    11053,    11065,    11077,    11089,    11101,    11113,
		11125,    11136,    11148,    11160,    11172,    11184,    11196,    11208,    11220,    11232,
		11244,    11256,    11268,    11280,    11291,    11303,    11315,    11327,    11339,    11351,
		11363,    11375,    11387,    11399,    11411,    11423,    11435,    11447,    11459,    11471,
		11483,    11495,    11507,    11519,    11531,    11542,    11554,    11566,    11578,    11590,
		11602,    11614,    11626,    11638,    11650,    11662,    11674,    11686,    11698,    11710,
		11722,    11734,    11746,    11758,    11770,    11782,    11794,    11806,    11818,    11830,
		11842,    11854,    11866,    11878,    11890,    11902,    11914,    11926,    11939,    11951,
		11963,    11975,    11987,    11999,    12011,    12023,    12035,    12047,    12059,    12071,
		12083,    12095,    12107,    12119,    12131,    12143,    12155,    12167,    12179,    12191,
		12203,    12216,    12228,    12240,    12252,    12264,    12276,    12288,    12300,    12312,
		12324,    12336,    12348,    12360,    12372,    12384,    12397,    12409,    12421,    12433,
		12445,    12457,    12469,    12481,    12493,    12505,    12517,    12529,    12542,    12554,
		12566,    12578,    12590,    12602,    12614,    12626,    12638,    12650,    12662,    12675,
		12687,    12699,    12711,    12723,    12735,    12747,    12759,    12771,    12783,    12796,
		12808,    12820,    12832,    12844,    12856,    12868,    12880,    12892,    12905,    12917,
		12929,    12941,    12953,    12965,    12977,    12989,    13001,    13014,    13026,    13038,
		13050,    13062,    13074,    13086,    13098,    13111,    13123,    13135,    13147,    13159,
		13171,    13183,    13195,    13208,    13220,    13232,    13244,    13256,    13268,    13280,
		13292,    13305,    13317,    13329,    13341,    13353,    13365,    13377,    13390,    13402,
		13414,    13426,    13438,    13450,    13462,    13474,    13487,    13499,    13511,    13523,
		13535,    13547,    13559,    13572,    13584,    13596,    13608,    13620,    13632,    13644,
		13657,    13669,    13681,    13693,    13705,    13717,    13729,    13742,    13754,    13766,
		13778,    13790,    13802,    13814,    13826,    13839,    13851,    13863,    13875,    13887,
		13899,    13911,    13924,    13936,    13948,    13960,    13972,    13984,    13996,    14009,
		14021,    14033,    14045,    14057,    14069,    14081,    14094,    14106,    14118,    14130,
		14142,    14154,    14166,    14178,    14191,    14203,    14215,    14227,    14239,    14251,
		14263,    14276,    14288,    14300,    14312,    14324,    14336,    14348,    14360,    14373,
		14385,    14397,    14409,    14421,    14433,    14445,    14457,    14470,    14482,    14494,
		14506,    14518,    14530,    14542,    14554,    14567,    14579,    14591,    14603,    14615,
		14627,    14639,    14651,    14664,    14676,    14688,    14700,    14712,    14724,    14736,
		14748,    14760,    14773,    14785,    14797,    14809,    14821,    14833,    14845,    14857,
		14869,    14881,    14894,    14906,    14918,    14930,    14942,    14954,    14966,    14978,
		14990,    15002,    15015,    15027,    15039,    15051,    15063,    15075,    15087,    15099,
		15111,    15123,    15135,    15148,    15160,    15172,    15184,    15196,    15208,    15220,
		15232,    15244,    15256,    15268,    15280,    15292,    15304,    15317,    15329,    15341,
		15353,    15365,    15377,    15389,    15401,    15413,    15425,    15437,    15449,    15461,
		15473,    15485,    15497,    15509,    15521,    15534,    15546,    15558,    15570,    15582,
		15594,    15606,    15618,    15630,    15642,    15654,    15666,    15678,    15690,    15702,
		15714,    15726,    15738,    15750,    15762,    15774,    15786,    15798,    15810,    15822,
		15834,    15846,    15858,    15870,    15882,    15894,    15906,    15918,    15930,    15942,
		15954,    15966,    15978,    15990,    16001,    16014,    16026,    16038,    16050,    16062,
		16074,    16085,    16097,    16110,    16122,    16134,    16146,    16158,    16170,    16181,
		16193,    16204,    16216,    16229,    16241,    16253,    16265,    16277,    16289,    16300,
		16312,    16325,    16337,    16349,    16361,    16373,    16385,    16396,    16408,    16420,
		16432,    16444,    16456,    16468,    16480,    16492,    16504,    16516,    16527,    16539,
		16551,    16563,    16575,    16587,    16599,    16611,    16623,    16634,    16646,    16658,
		16670,    16682,    16694,    16706,    16718,    16729,    16741,    16753,    16765,    16777,
		16789,    16801,    16812,    16824,    16836,    16848,    16860,    16872,    16883,    16895,
		16907,    16919,    16931,    16943,    16954,    16966,    16978,    16990,    17002,    17013,
		17025,    17037,    17049,    17061,    17072,    17084,    17096,    17108,    17120,    17131,
		17143,    17155,    17167,    17178,    17190,    17202,    17214,    17225,    17237,    17249,
		17261,    17272,    17284,    17296,    17308,    17319,    17331,    17343,    17355,    17366,
		17378,    17390,    17401,    17413,    17425,    17437,    17448,    17460,    17472,    17483,
		17495,    17507,    17518,    17530,    17542,    17553,    17565,    17577,    17588,    17600,
		17612,    17623,    17635,    17647,    17658,    17670,    17682,    17693,    17705,    17717,
		17728,    17740,    17751,    17763,    17775,    17786,    17798,    17809,    17821,    17832,
		17844,    17855,    17867,    17878,    17890,    17901,    17913,    17924,    17936,    17947,
		17959,    17970,    17982,    17993,    18004,    18016,    18027,    18039,    18050,    18061,
		18073,    18084,    18095,    18107,    18118,    18129,    18140,    18152,    18163,    18174,
		18185,    18196,    18208,    18219,    18230,    18241,    18252,    18263,    18274,    18285,
		18297,    18308,    18319,    18330,    18341,    18352,    18362,    18373,    18384,    18395,
		18406,    18417,    18428,    18439,    18449,    18460,    18471,    18482,    18493,    18503,
		18514,    18525,    18535,    18546,    18557,    18567,    18578,    18588,    18599,    18609,
		18620,    18630,    18641,    18651,    18661,    18672,    18682,    18693,
	};
#endif

#ifdef TYPE_T_LUT
const int16_t Thermocouple_Type_T::lut_offset = -270;
const uint16_t Thermocouple_Type_T::lut_size = 670;
const int32_t Thermocouple_Type_T::lut[670] = {
	-6258,    -6256,    -6255,    -6253,    -6251,    -6248,    -6245,    -6242,    -6239,    -6236,
		-6232,    -6228,    -6223,    -6219,    -6214,    -6209,    -6204,    -6198,    -6193,    -6187,
		-6180,    -6174,    -6167,    -6160,    -6153,    -6146,    -6138,    -6130,    -6122,    -6114,
		-6105,    -6096,    -6087,    -6078,    -6068,    -6059,    -6049,    -6038,    -6028,    -6017,
		-6007,    -5996,    -5985,    -5973,    -5962,    -5950,    -5938,    -5926,    -5914,    -5901,
		-5888,    -5876,    -5863,    -5850,    -5836,    -5823,    -5809,    -5795,    -5782,    -5767,
		-5753,    -5739,    -5724,    -5710,    -5695,    -5680,    -5665,    -5650,    -5634,    -5619,
		-5603,    -5587,    -5571,    -5555,    -5539,    -5523,    -5506,    -5489,    -5473,    -5456,
		-5439,    -5421,    -5404,    -5387,    -5369,    -5351,    -5334,    -5316,    -5297,    -5279,
		-5261,    -5242,    -5224,    -5205,    -5186,    -5167,    -5148,    -5128,    -5109,    -5089,
		-5070,    -5050,    -5030,    -5010,    -4989,    -4969,    -4949,    -4928,    -4907,    -4886,
		-4865,    -4844,    -4823,    -4802,    -4780,    -4759,    -4737,    -4715,    -4693,    -4671,
		-4648,    -4626,    -4604,    -4581,    -4558,    -4535,    -4512,    -4489,    -4466,    -4443,
		-4419,    -4395,    -4372,    -4348,    -4324,    -4300,    -4275,    -4251,    -4226,    -4202,
		-4177,    -4152,    -4127,    -4102,    -4077,    -4051,    -4026,    -4000,    -3975,    -3949,
		-3923,    -3897,    -3871,    -3844,    -3818,    -3791,    -3765,    -3738,    -3711,    -3684,
		-3657,    -3629,    -3602,    -3574,    -3547,    -3519,    -3491,    -3463,    -3435,    -3407,
		-3379,    -3350,    -3322,    -3293,    -3264,    -3235,    -3206,    -3177,    -3148,    -3118,
		-3089,    -3059,    -3030,    -3000,    -2970,    -2940,    -2910,    -2879,    -2849,    -2818,
		-2788,    -2757,    -2726,    -2695,    -2664,    -2633,    -2602,    -2571,    -2539,    -2507,
		-2476,    -2444,    -2412,    -2380,    -2348,    -2316,    -2283,    -2251,    -2218,    -2186,
		-2153,    -2120,    -2087,    -2054,    -2021,    -1987,    -1954,    -1920,    -1887,    -1853,
		-1819,    -1785,    -1751,    -1717,    -1683,    -1648,    -1614,    -1579,    -1545,    -1510,
		-1475,    -1440,    -1405,    -1370,    -1335,    -1299,    -1264,    -1228,    -1192,    -1157,
		-1121,    -1085,    -1049,    -1012,     -976,     -940,     -904,     -867,     -830,     -794,
		-757,     -720,     -683,     -646,     -608,     -571,     -534,     -496,     -459,     -421,
		-383,     -345,     -307,     -269,     -231,     -193,     -154,     -116,      -77,      -39,
		39,       78,      117,      156,      195,      234,      273,      312,      352,      391,
		431,      470,      510,      549,      589,      629,      669,      709,      749,      790,
		830,      870,      911,      951,      992,     1033,     1074,     1114,     1155,     1196,
		1238,     1279,     1320,     1362,     1403,     1445,     1486,     1528,     1570,     1612,
		1654,     1696,     1738,     1780,     1823,     1865,     1908,     1950,     1993,     2036,
		2079,     2122,     2165,     2208,     2251,     2294,     2338,     2381,     2425,     2468,
		2512,     2556,     2600,     2643,     2687,     2732,     2776,     2820,     2864,     2909,
		2953,     2998,     3043,     3087,     3132,     3177,     3222,     3267,     3312,     3358,
		3403,     3448,     3494,     3539,     3585,     3631,     3677,     3722,     3768,     3814,
		3860,     3907,     3953,     3999,     4046,     4091,     4138,     4185,     4232,     4279,
		4325,     4372,     4419,     4466,     4513,     4561,     4608,     4655,     4702,     4750,
		4798,     4845,     4893,     4941,     4988,     5036,     5084,     5132,     5180,     5228,
		5277,     5325,     5373,     5422,     5470,     5519,     5567,     5616,     5665,     5714,
		5763,     5812,     5861,     5910,     5959,     6008,     6057,     6107,     6156,     6206,
		6255,     6305,     6355,     6404,     6454,     6504,     6554,     6604,     6654,     6704,
		6754,     6805,     6855,     6905,     6956,     7006,     7057,     7107,     7158,     7209,
		7260,     7310,     7361,     7412,     7463,     7515,     7566,     7617,     7668,     7720,
		7771,     7823,     7874,     7926,     7977,     8029,     8080,     8132,     8185,     8237,
		8289,     8341,     8393,     8445,     8497,     8550,     8602,     8654,     8707,     8759,
		8812,     8865,     8917,     8970,     9023,     9076,     9129,     9182,     9235,     9288,
		9341,     9395,     9448,     9501,     9555,     9608,     9662,     9715,     9769,     9822,
		9876,     9930,     9984,    10038,    10092,    10146,    10200,    10254,    10308,    10362,
		10417,    10471,    10525,    10580,    10634,    10689,    10743,    10798,    10853,    10907,
		10962,    11017,    11072,    11127,    11182,    11237,    11292,    11347,    11403,    11458,
		11513,    11569,    11624,    11680,    11735,    11791,    11846,    11902,    11958,    12013,
		12069,    12125,    12181,    12237,    12293,    12349,    12405,    12461,    12518,    12574,
		12630,    12687,    12743,    12799,    12856,    12912,    12969,    13026,    13082,    13139,
		13196,    13253,    13310,    13366,    13423,    13480,    13537,    13595,    13652,    13709,
		13766,    13823,    13881,    13938,    13995,    14053,    14110,    14168,    14226,    14283,
		14341,    14399,    14456,    14514,    14572,    14630,    14688,    14746,    14804,    14862,
		14920,    14978,    15036,    15095,    15153,    15211,    15270,    15328,    15386,    15445,
		15503,    15562,    15621,    15679,    15738,    15797,    15856,    15914,    15973,    16032,
		16091,    16149,    16209,    16268,    16327,    16387,    16446,    16505,    16564,    16624,
		16683,    16742,    16802,    16861,    16921,    16980,    17040,    17100,    17159,    17219,
		17279,    17339,    17399,    17458,    17518,    17578,    17638,    17698,    17759,    17819,
		17879,    17939,    17999,    18060,    18120,    18180,    18241,    18301,    18362,    18422,
		18483,    18543,    18604,    18665,    18725,    18786,    18847,    18908,    18969,    19030,
		19091,    19152,    19213,    19274,    19335,    19396,    19457,    19518,    19579,    19641,
		19702,    19763,    19825,    19886,    19947,    20009,    20070,    20132,    20193,    20255,
		20317,    20378,    20440,    20502,    20563,    20625,    20687,    20748,    20810,    20872,
	};
#endif

