/* Copyright (c) 2019 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation 
  and/or other materials provided with the distribution.  
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products 
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner 
  that would cause the software to become subject to terms and conditions which 
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors 
  may be used to endorse or promote products derived from this software without 
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or 
  more patent holders.  This license does not release you from the requirement 
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT, 
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL 
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2019-01-10-7CBSD SLA
*/

#include "mbed.h"

// LED Blinking rate in milliseconds (Note: need to define the unit of a time duration i.e. seconds(s) or milliseconds(ms))
#define SLEEP_TIME                  500ms

// Initialise the digital pin that controls LED1
DigitalOut led(LED1);
// Initialise the serial object with TX and RX pins
static BufferedSerial  serial_port(USBTX, USBRX);

// The File handler is needed to allow printf commands to write to the terminal
FileHandle *mbed::mbed_override_console(int fd)
{
    return &serial_port;
}

// main() runs in its own thread in the OS
int main()
{
    // printing the Mbed OS version this example was written to the console
    printf("This Application has been developed on Mbed OS version 6.4\r\n");
    
    // printing the actual Mbed OS version that this application is using to the console.
    printf(
        "Mbed OS version %d.%d.%d is what this applicaiton is currently using\r\n",
        MBED_MAJOR_VERSION,
        MBED_MINOR_VERSION,
        MBED_PATCH_VERSION
    );
    
    // The loop will toggle the LED every 500ms(SLEEP_TIME = 500ms) and print LED1s current state to the terminal
    while (1) {
        led = !led;          // toggle LED1 state
        printf("LED1 state: %d \r\n", (uint8_t)led);
        ThisThread::sleep_for(SLEEP_TIME);
    }
}

