/* Copyright (c) 2021 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner
  that would cause the software to become subject to terms and conditions which
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors
  may be used to endorse or promote products derived from this software without
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or
  more patent holders.  This license does not release you from the requirement
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2021-01-10-7CBSD SLA
*/

/**
 * @file:    app_config.h
 * @brief:   This file contains pin mappings for SDP_K1 board
 */
#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

/*============= I N C L U D E S =============*/
#include <PinNames.h>
#include <stdint.h>

/*=============  D E F I N I T I O N S  =============*/

// **** Note for User: ACTIVE_DEVICE selection ****//
/* Define the device type here from the list of below device type defines
 * (one at a time. Defining more than one device can result into compile error).
 * e.g. #define DEV_AD4111 -> This will make AD4111 as an ACTIVE_DEVICE.
 * The ACTIVE_DEVICE is default set to AD4111, if device type is not defined.
 * */
//#define   DEV_AD4111

// **** Note for User: Interface type selection (SDP-120/Arduino) ****//
/* The ADI SDP_K1 can be used with both arduino headers or the 120-pin SDP
 * connector found on ADI evaluation boards. The default is the SDP connector.
 * */

// FIXME: Enable pin mapping according to host header type
#define ARDUINO
#ifdef ARDUINO
#define I2C_SCL D15 // I2C_SCL
#define I2C_SDA D14 // I2C_SDA

#define SPI_SS   D10 // SPI_CS
#define SPI_MISO D12 // SPI_MISO
#define SPI_MOSI D11 // SPI_MOSI
#define SPI_SCK  D13 // SPI_SCK

#else
#define I2C_SCL SDP_I2C_SCL // PH_7
#define I2C_SDA SDP_I2C_SDA // PC_9

#define SPI_SS   SDP_SPI_CS_A // PB_9
#define SPI_MISO SDP_SPI_MISO // PF_8
#define SPI_MOSI SDP_SPI_MOSI // PF_9
#define SPI_SCK  SDP_SPI_SCK  // PH_6
#endif

/** Common pin mappings */
#define LED_GREEN LED3

#define TRIGGER_OUT A0 // Trig_in of ADMX2001 EVM
#define TRIGGER_IN  A1 // Trig_out of ADMX2001 EVM

#endif //_APP_CONFIG_H_
