/***************************************************************************//**
 *   @file     platform_support.cpp
 *   @brief:   support functions and declarations for particular platform
 *   @details: This is a platform specific file that supports functionality
 *             required from application generic file. This file should be
 *             modified according to platform that you are working with.
********************************************************************************
 * Copyright (c) 2019, 2020 Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

/******************************************************************************/
/************************ Includes Files **************************************/
/******************************************************************************/
#include <mbed.h>
#include "platform_support.h"

/******************************************************************************/
/********************** Variables and User defined data types *****************/
/******************************************************************************/

#define BAUD_RATE        115200  // UART Communication Baud Rate

/******************************************************************************/
/************************ Variable Declarations *******************************/
/******************************************************************************/

// Configure and instantiate UART protocol and baud rate
// *Note: Multiple instances of 'Serial' port can be created with different pins
//        and baud rate settings. In that case, user must use desired 'Serial'
//        instance/object to access the serial data, since order of declaration
//        depends upon the user and compiler.
static Serial port(USBTX, USBRX, BAUD_RATE);

/******************************************************************************/
/************************ Functions Definitions *******************************/
/******************************************************************************/

/**
  * @brief  getchar, but does not block if nothing waiting to be read
  * @param  None
  * @retval character if available, NULL otherwise
  */
char getchar_noblock(void)
{
	char rx_char = '\0';

	// Return the character read from the serial port
	if (port.readable() > 0) {
		rx_char = port.getc();
	}

	return rx_char;
}
