/***************************************************************************//**
 * @file    main.c
 * @brief   Main interface for AD7768-1 IIO firmware application
 * @details
********************************************************************************
* Copyright (c) 2021 Analog Devices, Inc.
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*******************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/
#include <assert.h>

#include "ad77681_iio.h"
#include "error.h"

/******************************************************************************/
/********************* Macros and Constants Definition ************************/
/******************************************************************************/

/******************************************************************************/
/******************** Variables and User Defined Data Types *******************/
/******************************************************************************/

/******************************************************************************/
/************************** Functions Declaration *****************************/
/******************************************************************************/

/******************************************************************************/
/************************** Functions Definition ******************************/
/******************************************************************************/

/* @brief	Main function
 * @details	This is a main entry function for firmware application
 */
int main(void)
{
	if (ad77681_iio_initialize() == FAILURE) {
		assert(false);
	}

	while (true) {
		// Execute forever loop
		ad77681_iio_event_handler();
	}

	// this line should never be reached
	return (FAILURE);
}
