/***************************************************************************//*
 * @file    app_config.h
 * @brief   Configuration file for AD77681 IIO firmware application
 * @details
******************************************************************************
 * Copyright (c) 2021 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
******************************************************************************/

#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

/* List of supported platforms*/
#define	MBED_PLATFORM		1

/* Select the active platform */
#define ACTIVE_PLATFORM		MBED_PLATFORM

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Name of active device */
#define ACTIVE_DEVICE_NAME	"ad7768-1"

#if (ACTIVE_PLATFORM == MBED_PLATFORM)
#include "app_config_mbed.h"

/* Used to form a VCOM serial number */
#define	FIRMWARE_NAME	"ad77681_mbed_iio_application"

/* Redefine the init params structure mapping w.r.t. platform */
#define uart_init_extra_params mbed_uart_extra_init_param
#define spi_init_extra_params mbed_spi_init_extra_params
#else
#error "No/Invalid active platform selected"
#endif

/* ADC resolution for active device */
#define ADC_RESOLUTION		24

/* Baud rate for IIO application UART interface */
#define IIO_UART_BAUD_RATE (230400)

/****** Macros used to form a VCOM serial number ******/
#if !defined(DEVICE_NAME)
#define DEVICE_NAME		"DEV_AD77681"
#endif

#if !defined(PLATFORM_NAME)
#define PLATFORM_NAME	"SDP_K1"
#endif
/******/

/* Enable the VirtualCOM port connection/interface. By default serial communication
 * is physical UART */
//#define USE_VIRTUAL_COM_PORT

#if defined(USE_VIRTUAL_COM_PORT)
/* Below USB configurations (VID and PID) are owned and assigned by ADI.
 * If intended to distribute software further, use the VID and PID owned by your
 * organization */
#define VIRTUAL_COM_PORT_VID	0x0456
#define VIRTUAL_COM_PORT_PID	0xb66c
/* Serial number string is formed as: application name + device (target) name + platform (host) name */
#define VIRTUAL_COM_SERIAL_NUM	(FIRMWARE_NAME "_" DEVICE_NAME "_" PLATFORM_NAME)
#endif

/******************************************************************************/
/************************ Public Declarations *********************************/
/******************************************************************************/

int32_t init_system(void);

extern struct uart_init_param uart_init_params;
extern struct gpio_desc *led_green_gpio_desc;


#endif /* _APP_CONFIG_H_ */
