/***************************************************************************//**
 *   @file    app_config_mbed.c
 *   @brief   Application configurations module for Mbed platform
 *   @details This module contains the configurations needed for IIO application
********************************************************************************
 * Copyright (c) 2021 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdbool.h>
#include "app_config.h"
#include "app_config_mbed.h"

/******************************************************************************/
/************************ Macros/Constants ************************************/
/******************************************************************************/

/******************************************************************************/
/*************************** Types Declarations *******************************/
/******************************************************************************/

/* UART Mbed platform parameters structure */
mbed_uart_init_param mbed_uart_extra_init_param = {
#if defined(USE_VIRTUAL_COM_PORT)
	.virtual_com_enable = true,
	.vendor_id = VIRTUAL_COM_PORT_VID,
	.product_id = VIRTUAL_COM_PORT_PID,
	.serial_number = VIRTUAL_COM_SERIAL_NUM
#else
	.uart_tx_pin = UART_TX,
	.uart_rx_pin = UART_RX,
	.virtual_com_enable = false
#endif
};

/* Define external interrupt platform specific parameters structure */
mbed_irq_init_param mbed_ext_int_init_param = {
	.int_mode = EXT_IRQ_FALL,
	.ext_int_pin = DRDY,
};

/* SPI Mbed platform parameters structure */
mbed_spi_init_param mbed_spi_init_extra_params = {
	.spi_clk_pin = SPI_SCK,
	.spi_miso_pin = SPI_MISO,
	.spi_mosi_pin = SPI_MOSI
};


/******************************************************************************/
/************************ Functions Prototypes ********************************/
/******************************************************************************/

/******************************************************************************/
/************************ Functions Definitions *******************************/
/******************************************************************************/
