/***************************************************************************//**
*   @file   iio_ad7606.h
*   @brief  Header file of iio_ad7606
********************************************************************************
* Copyright (c) 2020-2021 Analog Devices, Inc.
*
* All rights reserved.
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*******************************************************************************/
#ifndef IIO_AD7606_H_
#define IIO_AD7606_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdio.h>
#include <stdbool.h>
#include "iio.h"
#include "iio_types.h"

/******************************************************************************/
/****************************** Macros ****************************************/
/******************************************************************************/

/******************************************************************************/
/*************************** Types Declarations *******************************/
/******************************************************************************/

/******************************************************************************/
/*************************** Public Declarations ******************************/
/******************************************************************************/

/* Init the IIO interface */
int32_t ad7606_iio_initialize(void);

/* Run the IIO event handler */
void ad7606_iio_event_handler(void);

extern struct ad7606_dev *p_ad7606_dev_inst;

#endif /* IIO_AD7606_H_ */
