/*************************************************************************//**
 *   @file   app_config.h
 *   @brief  Configuration file for AD717x/AD411x firmware example
******************************************************************************
* Copyright (c) 2020 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/
#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/
#include <stdint.h>
#include <PinNames.h>

/******************************************************************************/
/********************** Macros and Constants Definitions **********************/
/******************************************************************************/

// **** Note for User: ACTIVE_DEVICE selection ****//
/* Define the device type here from the list of below device type defines
 * (one at a time. Defining more than one device can result into compile error).
 * e.g. #define DEV_AD4111 -> This will make AD4111 as an ACTIVE_DEVICE.
 * The ACTIVE_DEVICE is default set to AD4111, if device type is not defined.
 * */
//#define	DEV_AD4111

// **** Note for User: Interface type selection (SDP-120/Arduino) ****//
/* The ADI SDP_K1 can be used with both arduino headers or the 120-pin SDP
 * connector found on ADI evaluation boards. The default is the SDP connector.
 * */
//#define	ARDUINO


// Pin mapping of AD717x with SDP-K1/Arduino (reference: PinNames.h)
#ifdef ARDUINO
#define I2C_SCL		D15		// I2C_SCL
#define I2C_SDA		D14		// I2C_SDA

#define SPI_SS		D10		// SPI_CS
#define SPI_MISO	D12		// SPI_MISO
#define SPI_MOSI	D11		// SPI_MOSI
#define SPI_SCK		D13		// SPI_SCK
#else
#define I2C_SCL		SDP_I2C_SCL		// PH_7
#define I2C_SDA		SDP_I2C_SDA		// PC_9

#define SPI_SS		SDP_SPI_CS_A	// PB_9
#define SPI_MISO	SDP_SPI_MISO	// PF_8
#define SPI_MOSI	SDP_SPI_MOSI	// PF_9
#define SPI_SCK		SDP_SPI_SCK		// PH_6
#endif

// Common pin mappings
#define LED_GREEN	LED3


#if defined(DEV_AD4111)
#define ACTIVE_DEVICE_NAME	"AD4111"
#elif defined(DEV_AD4112)
#define ACTIVE_DEVICE_NAME	"AD4112"
#elif defined(DEV_AD4114)
#define ACTIVE_DEVICE_NAME	"AD4114"
#elif defined(DEV_AD4115)
#define ACTIVE_DEVICE_NAME	"AD4115"
#elif defined(DEV_AD7172_2)
#define AD7172_2_INIT
#define ACTIVE_DEVICE_NAME	"AD7172-2"
#elif defined(DEV_AD7172_4)
#define AD7172_4_INIT
#define ACTIVE_DEVICE_NAME	"AD7172-4"
#elif defined(DEV_AD7173_8)
#define AD7173_8_INIT
#define ACTIVE_DEVICE_NAME	"AD7173-8"
#elif defined(DEV_AD7175_2)
#define AD7175_2_INIT
#define ACTIVE_DEVICE_NAME	"AD7175-2"
#elif defined(DEV_AD7175_8)
#define AD7175_8_INIT
#define ACTIVE_DEVICE_NAME	"AD7175-8"
#elif defined(DEV_AD7176_2)
#define AD7176_2_INIT
#define ACTIVE_DEVICE_NAME	"AD7176-2"
#elif defined(DEV_AD7177_2)
#define AD7177_2_INIT
#define ACTIVE_DEVICE_NAME	"AD7177-2"
#else
#warning No/Unsupported ADxxxxy symbol defined. AD4111 defined
#define DEV_AD4111
#define ACTIVE_DEVICE_NAME	"AD4111"
#endif

#endif //_APP_CONFIG_H_
