/*************************************************************************//**
 *   @file   ad717x_support.c
 *   @brief  Support file for AD717X device configurations
******************************************************************************
* Copyright (c) 2022 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad717x_support.h"
#include "ad717x_iio.h"
#include "no_os_error.h"

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/

/******************************************************************************/
/************************** Functions Declarations ****************************/
/******************************************************************************/

/******************************************************************************/
/************************ Functions Definitions *******************************/
/******************************************************************************/

/**
 * @brief Enable/Disable continuous read mode
 * @param device[in] - The AD717x Device descriptor
 * @param cont_read_en[in] - True in case of enable CONT_READ/ False in case of disable
 * @return 0 in case of success, negative error code otherwise
 */
int32_t ad717x_enable_cont_read(ad717x_dev *device, bool cont_read_en)
{
	ad717x_st_reg *ifmode_reg;
	int32_t ret;

	/* Retrieve the IFMODE Register */
	ifmode_reg = AD717X_GetReg(p_ad717x_dev_inst, AD717X_IFMODE_REG);
	if (!ifmode_reg) {
		return -EINVAL;
	}

	if (cont_read_en) {
		ifmode_reg->value |= (AD717X_IFMODE_REG_CONT_READ);
	} else {
		ifmode_reg->value &= ~(AD717X_IFMODE_REG_CONT_READ);
	}

	ret = AD717X_WriteRegister(p_ad717x_dev_inst, AD717X_IFMODE_REG);
	if (ret) {
		return ret;
	}

	return 0;
}
