/*************************************************************************//**
 *   @file   ad717x_iio.h
 *   @brief  IIO Header file for AD717x and AD411x
******************************************************************************
* Copyright (c) 2021-22 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

#ifndef AD717x_IIO_H_
#define AD717x_IIO_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>
#include "iio.h"
#include "ad717x.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/

/******************************************************************************/
/************************ Public Declarations *********************************/
/******************************************************************************/

extern ad717x_dev *p_ad717x_dev_inst;
int32_t ad717x_iio_initialize(void);
void ad717x_iio_event_handler(void);

#endif // AD717x_IIO_H_

