/***************************************************************************//**
 *   @file    ad717x_data_capture.h
 *   @brief   Header file for AD717x Data capture
********************************************************************************
 * Copyright (c) 2021-22 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

#ifndef _AD717X_DATA_CAPTURE_H_
#define _AD717X_DATA_CAPTURE_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>
#include "app_config.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

#if defined(USE_SDRAM_CAPTURE_BUFFER)
#define adc_data_buffer				SDRAM_START_ADDRESS
#define DATA_BUFFER_SIZE			SDRAM_SIZE_BYTES
#else
extern int8_t adc_data_buffer[];
#define DATA_BUFFER_SIZE			(32768)		// 32kbytes
#endif

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

int32_t prepare_data_transfer(uint32_t ch_mask, uint8_t num_of_chns,
			      uint8_t sample_size_in_byte);
int32_t end_data_transfer(void);
int32_t read_buffered_data(int8_t **pbuf, uint32_t nb_of_bytes);
void data_capture_callback(void *ctx, uint32_t event, void *extra);

#endif /* _AD717X_DATA_CAPTURE_H_ */

