/*************************************************************************//**
 *   @file   app_config.h
 *   @brief  Configuration file of AD7124 firmware example program
******************************************************************************
* Copyright (c) 2020 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

#include <stdint.h>
#include <PinNames.h>

/**
  The ADI SDP_K1 can be used with both arduino headers
  or the 120-pin SDP connector found on ADI evaluation
  boards. The default is the SDP connector.

  Uncomment the ARDUINO #define below to enable the ARDUINO connector
*/

//#define  ARDUINO

// Pin mapping of AD7124 with SDP-K1/Arduino (reference: PinNames.h)
#ifdef ARDUINO
#define SPI_SS_A	D10		// SPI_CS
#define SPI_MISO	D12		// SPI_MISO
#define SPI_MOSI	D11		// SPI_MOSI
#define SPI_SCK		D13		// SPI_SCK
#else
#define SPI_SS_A	SDP_SPI_CS_A	// PB_9
#define SPI_MISO	SDP_SPI_MISO	// PF_8
#define SPI_MOSI	SDP_SPI_MOSI	// PF_9
#define SPI_SCK		SDP_SPI_SCK		// PH_6
#endif

// Common pin mappings
#define LED_GREEN	LED3	// PK_5

#endif //_APP_CONFIG_H_
