/*!
 *****************************************************************************
  @file:  app_config.h
  @brief: AD5592R/AD5593R device selection. Pin mappings.
  @details:
 -----------------------------------------------------------------------------
 Copyright (c) 2020 Analog Devices, Inc.
 All rights reserved.

 This software is proprietary to Analog Devices, Inc. and its licensors.
 By using this software you agree to the terms of the associated
 Analog Devices Software License Agreement.
*****************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/
#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

#include <stdint.h>
#include <PinNames.h>

/******************************************************************************/
/************************* Macros & Constant Definitions ***************************/
/******************************************************************************/
// Supported Devices
#define ID_AD5592R 0
#define ID_AD5593R 1

#define AD5593R_A0_STATE 0

// **** Note for User: ACTIVE_DEVICE selection ****
// Define the device type here from the list of below device type defines
// e.g. #define ACTIVE_DEVICE ID_AD5593R -> This will set AD5593R as an ACTIVE_DEVICE.
// The ACTIVE_DEVICE is default set to AD5592R, if device type is not defined.

#ifndef ACTIVE_DEVICE
#define ACTIVE_DEVICE ID_AD5592R
//#define ACTIVE_DEVICE ID_AD5593R
#endif

#define NUM_CHANNELS 8

#define AD5593R_I2C (0x10 | (AD5593R_A0_STATE & 0x01))

// Using Arduino header
#define I2C_SCL		D15 // (PB_8)	
#define I2C_SDA		D14 // (PB_7)	

// Using 120 Pin SDP connector
#define SPI_SS_A	SDP_SPI_CS_A // (PB_9)	0x19
#define SPI_SS_B	SDP_SPI_CS_B // (PC_6)	0x26
#define SPI_SS_C	SDP_SPI_CS_C // (PC_7)	0x27
#define SPI_MOSI	SDP_SPI_MOSI // (PF_9)	0x58
#define SPI_MISO	SDP_SPI_MISO // (PF_8)	0x59
#define SPI_SCK		SDP_SPI_SCK // (PH_6)	0x76

#endif //_APP_CONFIG_H_
