/***************************************************************************//**
*   @file   iio_ad4696.h
*   @brief  Header file of iio_ad4696
********************************************************************************
* Copyright (c) 2021 Analog Devices, Inc.
*
* All rights reserved.
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*******************************************************************************/
#ifndef IIO_AD4696_H_
#define IIO_AD4696_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdio.h>
#include <stdbool.h>

#include "iio.h"
#include "iio_types.h"

/******************************************************************************/
/****************************** Macros ****************************************/
/******************************************************************************/

/******************************************************************************/
/*************************** Types Declarations *******************************/
/******************************************************************************/

/*  AD4696 global device instance for accessing device specific APIs */
extern struct ad469x_dev *p_ad4696_dev;

/******************************************************************************/
/************************ Functions Declarations ******************************/
/******************************************************************************/

/* Init the IIO interface */
int32_t ad4696_iio_initialize(void);

/* Run the IIO event handler */
void ad4696_iio_event_handler(void);

#endif /* IIO_AD4696_H_ */