/***************************************************************************//**
 *   @file    main.c
 *   @brief   Main module for AD4696 IIO application
 *   @details This module invokes the AD4696 IIO interfaces
 *            through forever loop.
********************************************************************************
 * Copyright (c) 2021 Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/
#include <stdint.h>
#include <assert.h>

#include "iio_ad4696.h"
#include "error.h"

/******************************************************************************/
/********************** Macros and Constants Definitions **********************/
/******************************************************************************/

/******************************************************************************/
/************************ Functions Definitions *******************************/
/******************************************************************************/

/**
 * @brief	Main entry point to application
 * @return	none
 */
int main(void)
{
	/* Initialize the AD4696 IIO interface */
	if (ad4696_iio_initialize() == FAILURE) {
		assert(false);
	}
	
	while (1) {
		/* Monitor the IIO client events */
		ad4696_iio_event_handler();
	}
}

