/*************************************************************************//**
 *   @file   ad4110_thermocouple_mode_mode_config.h
 *   @brief  Header for AD4110 thermocouple configurations module
******************************************************************************
* Copyright (c) 2022 Analog Devices, Inc.
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

#ifndef _AD4110_THERMOCOUPLE_MODE_CONFIG_H_
#define _AD4110_THERMOCOUPLE_MODE_CONFIG_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad4110.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Note: AD4110_DEFAULT_PGA value is applied during calculation of actual quantity
* from the ADC raw value. GAIN_CH holds the value of the bitfield needed while
* configuring the gain in the device during initialization. It has to be ensured
* that these values are in match with each other */
#define AD4110_DEFAULT_PGA		24
#define GAIN_CH				AD4110_GAIN_24

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/

extern struct ad4110_init_param ad4110_thermocouple_mode_init_params;

#endif /* end of _AD4110_THERMOCOUPLE_MODE_CONFIG_H_ */
