/***************************************************************************//*
 * @file  ad4110_field_power_supply_mode.h
 * @brief Demo mode configurations header for AD4110 field power supply mode
******************************************************************************
 * Copyright (c) 2022 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
******************************************************************************/

#ifndef _AD4110_FIELD_POWER_SUPPLY_MODE_
#define _AD4110_FIELD_POWER_SUPPLY_MODE_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad4110.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Note: AD4110_DEFAULT_PGA value is applied during calculation of actual quantity
* from the ADC raw value. GAIN_CH holds the value of the bitfield needed while
* configuring the gain in the device during initialization. It has to be ensured
* that these values are in match with each other */
#define AD4110_DEFAULT_PGA		4
#define GAIN_CH				AD4110_GAIN_4

/* Value of Internal resistance connected for field power supply mode */
#define AD4110_R_SENSE		24

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

extern struct ad4110_init_param ad4110_field_power_supply_mode_init_params;

#endif /* _AD4110_FIELD_POWER_SUPPLY_MODE_ */