/*************************************************************************//**
 *   @file   ad4110_current_mode_config.c
 *   @brief  Current mode user configurations module for AD4110 IIO firmware
******************************************************************************
* Copyright (c) 2022 Analog Devices, Inc.
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad4110.h"
#include "app_config.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/


/* AD4110-1 Init parameters*/
struct ad4110_init_param ad4110_current_mode_init_params = {
	.spi_init = {
		.max_speed_hz = 10000000,
		.chip_select = SPI_CSB,
		.mode = NO_OS_SPI_MODE_3,
		.extra = &spi_extra_init_params,
		.platform_ops = &spi_platform_ops
	},
	.volt_ref = AD4110_EXT_REF,
	.data_stat = AD4110_DISABLE,
	.data_length = AD4110_DATA_WL24,
	.afe_crc_en = AD4110_AFE_CRC_DISABLE,
	.adc_crc_en = AD4110_ADC_CRC_DISABLE,
	.op_mode = AD4110_CURRENT_MODE_EXT_R_SEL,
	.gain = GAIN_CH,
	.sync = AD4110_SYNC_EN,
	.afe_clk = AD4110_AFE_ADC_CLOCKED,
	.adc_clk = AD4110_ADC_INT_CLK_CLKIO,
	.addr = 0,
	.bipolar = true,
	.analog_input_buff = ENABLE_FULL_BUFFER,
	.odr = AD4110_ODR_SEL,
	.order = sinc5_sinc1
} ;