/***************************************************************************//*
 * @file    ad4110_support.h
 * @brief   AD4110 No-OS driver support header file
******************************************************************************
 * Copyright (c) 2022 Analog Devices, Inc. All Rights Reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
******************************************************************************/
#ifndef AD4110_SUPPORT_H_
#define AD4110_SUPPORT_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdlib.h>

/******************************************************************************/
/********************* Macros and Constants Definitions ***********************/
/******************************************************************************/

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

float convert_adc_raw_into_rtd_resistance(uint32_t adc_raw, float rtd_ref);
int32_t perform_sign_conversion(uint32_t adc_raw_data);
float convert_adc_sample_into_voltage(uint32_t adc_raw, uint8_t channel_id);

#endif	/* end of AD4110_SUPPORT_H_ */
