/***************************************************************************//**
 *   @file    app_config_mbed.h
 *   @brief   Header file for Mbed platform configurations
********************************************************************************
 * Copyright (c) 2022 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

#ifndef APP_CONFIG_MBED_H_
#define APP_CONFIG_MBED_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>
#include <PinNames.h>
#include "mbed_uart.h"
#include "mbed_spi.h"
#include "mbed_irq.h"
#include "mbed_gpio.h"

#if defined(TARGET_SDP_K1)
#include "sdram_sdpk1.h"
#endif

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/
/**
 * The ADI SDP_K1 can be used with either arduino headers
 * or the 120-pin SDP connector found on ADI evaluation
 * boards. The default is the Arduino connector.
 *
 * Comment the SDP_120 #define below to enable the Arduino connector
*/

// #define  SDP_120

#if defined (SDP_120)
/* Pin mapping of AD4110-1 with SDP-K1 SDP headers */
#define SPI_CSB	        SDP_SPI_CS_A
#define SPI_HOST_SDO	SDP_SPI_MOSI
#define SPI_HOST_SDI	SDP_SPI_MISO
#define SPI_SCK		SDP_SPI_SCK
#else
/* Pin mapping of SDP-K1 w.r.t Arduino connector */
#define SPI_CSB		ARDUINO_UNO_D10
#define SPI_HOST_SDO	ARDUINO_UNO_D11
#define SPI_HOST_SDI	ARDUINO_UNO_D12
#define SPI_SCK		ARDUINO_UNO_D13
#endif

/* Common Pin mapping of UART */
#define UART_TX		CONSOLE_TX
#define	UART_RX		CONSOLE_RX

/* RDY pin- which gives the end of conversion status.
This pin is also the MISO pin for SPI communications */
#define RDY_PIN	    SPI_HOST_SDI

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

extern struct mbed_uart_init_param mbed_uart_extra_init_params;
extern struct mbed_spi_init_param mbed_spi_extra_init_params;
extern struct mbed_irq_init_param mbed_ext_int_extra_init_params;

#endif /* APP_CONFIG_MBED_H_ */

