/***************************************************************************//**
*   @file   ad4110_iio.h
*   @brief  Header file of AD4110-1 IIO interfaces
********************************************************************************
* Copyright (c) 2022 Analog Devices, Inc.
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*******************************************************************************/
#ifndef AD4110_IIO_H_
#define AD4110_IIO_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdint.h>
#include "iio.h"
#include "ad4110.h"

/******************************************************************************/
/************************ Macros/Constants ************************************/
/******************************************************************************/

/* CJC has been incorporated on channel 1 (LV Channel) */
#define CJC_CHANNEL	1
#define HV_CHANNEL	0

/******************************************************************************/
/************************ Public Declarations *********************************/
/******************************************************************************/

extern struct ad4110_dev *ad4110_dev_inst;
int32_t ad4110_iio_initialize(void);
void ad4110_iio_event_handler(void);

#endif // AD4110_IIO_H_

