# @file    ad4110_xattr.py
# @brief   Extended attributes for the AD4110
#
# Copyright (c) 2022 Analog Devices, Inc.
# All rights reserved.
# 
# This software is proprietary to Analog Devices, Inc. and its licensors.
# By using this software you agree to the terms of the associated
# Analog Devices Software License Agreement.
#

import adi.ad4110 
from adi.ad4110 import ad4110
from adi.attribute import attribute
from decimal import Decimal

# Create a child class of ad4110 parent class for defining extended iio attributes (the ones which
# are not part of original linux iio drivers and created for non-linux iio applications)
class ad4110_xattr(ad4110):

    #------------------------------------------------
    # Device extended attributes
    #------------------------------------------------
    
    @property
    def demo_config(self):
        """AD4110 demo mode config"""
        return self._get_iio_dev_attr_str("demo_config")

    @property
    def sample_rate(self):
        """AD4110 device sample_rate"""
        return int(self._get_iio_dev_attr_str("sampling_frequency"))