/***************************************************************************//*
 * @file    ad4110_user_config.h
 * @brief   User configurations for AD4110-1 No-OS driver
******************************************************************************
 * Copyright (c) 2022 Analog Devices, Inc.
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
******************************************************************************/

#ifndef AD4110_USER_CONFIG_H_
#define AD4110_USER_CONFIG_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad4110.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Note: AD4110_DEFAULT_PGA value is applied during calculation of actual quantity
* from the ADC raw value. GAIN_CH holds the value of the bitfield needed while
* configuring the gain in the device during initialization. It has to be ensured
* that these values are in match with each other */
#define AD4110_DEFAULT_PGA  	0.2
#define GAIN_CH		    	AD4110_GAIN_0_2

/******************************************************************************/
/********************** Public/Extern Declarations ****************************/
/******************************************************************************/

extern struct ad4110_init_param ad4110_user_config_params;

#endif /* AD4110_USER_CONFIG_H_ */

