/*************************************************************************//**
 *   @file   ad4110_rtd_mode_config.h
 *   @brief  RTD Mode Configuration for AD4110 IIO Application
******************************************************************************
* Copyright (c) 2022 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

#ifndef AD4110_RTD_MODE_CONFIG_H_
#define AD4110_RTD_MODE_CONFIG_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "ad4110.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* RTD Mode Configurarion. Uncomment any one mode to select the
 * Mode of operation. Default is 2-wire*/
#define	RTD_2WIRE_CONFIG
// #define RTD_3WIRE_CONFIG
// #define RTD_4WIRE_CONFIG

/* Note: AD4110_DEFAULT_PGA value is applied during calculation of actual quantity
* from the ADC raw value. GAIN_CH holds the value of the bitfield needed while
* configuring the gain in the device during initialization. It has to be ensured
* that these values are in match with each other */
#define AD4110_DEFAULT_PGA		8
#define GAIN_CH				AD4110_GAIN_8

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/

/******************************************************************************/
/************************ Public Declarations *********************************/
/******************************************************************************/

extern struct ad4110_init_param ad4110_rtd_mode_init_params;

#endif // AD4110_RTD_MODE_CONFIG_H_

