#include "mbed.h"
#include "ADXL362.h"

ADXL362 adxl362(D9);

int main() {
    
    adxl362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    uint8_t x,y,z; 
    while(1) {
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        printf("x = %x y = %x z = %x\r\n",x,y,z);
        wait_ms(100);
    }
}
