/* Copyright (c) 2021 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation 
  and/or other materials provided with the distribution.  
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products 
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner 
  that would cause the software to become subject to terms and conditions which 
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors 
  may be used to endorse or promote products derived from this software without 
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or 
  more patent holders.  This license does not release you from the requirement 
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT, 
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL 
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2021-01-10-7CBSD SLA
*/

/**
 *  @file   message.h
 *  @brief  Defines for message
 */

#ifndef __MESSAGE_H__
#define __MESSAGE_H__

/*============= I N C L U D E S =============*/
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
/*============= D E F I N E S =============*/
/** Maximum message size value */
#define MAX_MSG_SIZE 128

/** No Warning */
#define NO_WARN 0
/** DDS & NCO Frequency are not equal warning */
#define DDS_NCO_FREQ_WARN 1
/** Calibration failed warning */
#define CAL_LOAD_FAIL_WARN 2
/** Autorange disabled warning */
#define AUTORANGE_DISABLE_WARN 4
/** Autorange failed warning */
#define AUTORANGE_FAIL_WARN 8
/** Sweep count warning */
#define SWEEPCOUNT_WARN 16
/** Magnitude limit warning */
#define MAG_EXCEED_WARN 32
/** Offset limit warning */
#define OFFSET_LIMITED_WARN 64
/** Positive offset exceed warning */
#define OFFSET_POS_EXCEED_WARN 128
/** Negative offset exceed warning */
#define OFFSET_NEG_EXCEED_WARN 256

//#define ENABLE_DEBUG

/** Prints Info  Message */
#define INFO_MSG(X) printf("%s\n\r", X);
/** Prints warn message */
#define WARN_MSG(X) printf("Warn : %s\n\r", X);
/** Prints error message */
#define ERROR_MSG(X) printf("Error : %s\n\r", X);

#endif /* __MESSAGE_H__ */
