/* Copyright (c) 2021 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation 
  and/or other materials provided with the distribution.  
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products 
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner 
  that would cause the software to become subject to terms and conditions which 
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors 
  may be used to endorse or promote products derived from this software without 
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or 
  more patent holders.  This license does not release you from the requirement 
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT, 
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL 
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2021-01-10-7CBSD SLA
*/

/**
 * @file     ADMX2001_commands.h
 * @brief    This file contains Macros for the SPI Commands
 */

#ifndef __ADMX200X_COMMANDS_H__
#define __ADMX200X_COMMANDS_H__

/** Bit mask to indicate read or write */
#define CMD_READ_BITM 0x80

/** Length of a command */
#define ADMX200X_CMD_LENGTH 7

/** Basic commands */
/** Read status */
#define CMD_STATUS_READ 0x00U
/** Read result */
#define CMD_RESULT_READ 0x01
/** Clear error */
#define CMD_CLEAR_ERROR 0x02
/** Read fifo */
#define CMD_FIFO_READ 0x03
/**  Command to calibrate */
#define CMD_CALIBRATE 0x04
/** Command to read compensation value */
#define CMD_COMPENSATION 0x5
/** Command to read calibration coefficient */
#define CMD_CAL_READ 0x06
/** Command to store calibration coefficient */
#define CMD_STORE_CAL 0x08
/** Command to store calibration coefficient */
#define CMD_RESET_CAL 0x09
/** Command to swithc on or off error check */
#define CMD_ERR_CHECK 0xa
/** Command to swithc on or off error check */
#define CMD_SELF_TEST 0xb
/** Command to read calibration coefficient */
#define CMD_COMP_READ 0xc
/** Command to store calibration coefficient */
#define CMD_STORE_COMP 0xd
/** Command to read temperature */
#define CMD_TEMPERATURE 0xe
/** Command Z */
#define CMD_Z 0xf
/** Read sweep points */
#define CMD_READ_SWEEP_POINTS 0x11
/** Reset */
#define CMD_RESET 0x12
/** Current gain table */
#define CMD_CURRENT_GAIN_TABLE 0x13
/** Voltage gain table */
#define CMD_VOLTAGE_GAIN_TABLE 0x14
/** Version Details */
#define CMD_VERSION 0x15
/** Command to read or write spi regsiters */
#define CMD_IP_REGISTERS 0x16
/** Initiates the measurement */
#define CMD_INITIATE (0x17)
/** Triggers the measurement */
#define CMD_TRIGGER (0x18)
/** Fetch the last measurement */
#define CMD_FETCH (0x19)
/** Aborts the measurement */
#define CMD_ABORT (0x1a)
/** Calibration commit command */
#define CMD_CAL_COMMIT (0x1b)
/** Calibration commit password set */
#define CMD_SET_PASSWORD (0x1c)
/** Calibration commit get password */
#define CMD_GET_PASSWORD (0x1d)
/** Command to read or write spi regsiters with address more than uint16 */
#define CMD_IP_REGISTERS_U32 (0x1e)

/**  Base of attribute commands  */
#define CMD_ATTR_BASE (0x20)
/**  lcr frequecny */
#define CMD_FREQUENCY (CMD_ATTR_BASE + 3)
/**  lcr integration time */
#define CMD_INTEGRATION (CMD_ATTR_BASE + 4)
/**  dds magnitude */
#define CMD_MAGNITUDE (CMD_ATTR_BASE + 5)
/**   dds offset */
#define CMD_OFFSET (CMD_ATTR_BASE + 6)
/**  dds gain */
#define CMD_DDS_GAIN (CMD_ATTR_BASE + 7)
/**  lcr voltage gain */
#define CMD_VOLTAGE_GAIN (CMD_ATTR_BASE + 8)
/**  lcr current gain */
#define CMD_CURRENT_GAIN (CMD_ATTR_BASE + 9)
/**  lcr average */
#define CMD_AVERAGE (CMD_ATTR_BASE + 10)
/**  lcr measurement delay */
#define CMD_MDELAY (CMD_ATTR_BASE + 11)
/**  lcr trigger delay */
#define CMD_TDELAY (CMD_ATTR_BASE + 12)
/**  lcr trigger count */
#define CMD_TCOUNT (CMD_ATTR_BASE + 13)
/** Sweep Start */
#define CMD_SWEEP_START (CMD_ATTR_BASE + 16)
/** Sweep End*/
#define CMD_SWEEP_END (CMD_ATTR_BASE + 17)
/** Sweep Type */
#define CMD_SWEEP_TYPE (CMD_ATTR_BASE + 18)
/** lcr sweep scale log or linear */
#define CMD_SWEEP_SCALE (CMD_ATTR_BASE + 19)
/** lcr cycles */
#define CMD_CYCLES (CMD_ATTR_BASE + 20)
/** lcr celsius */
#define CMD_CELSIUS (CMD_ATTR_BASE + 27)
/** lcr radians */
#define CMD_RADIANS (CMD_ATTR_BASE + 28)
/** lcr lock */
#define CMD_LOCK (CMD_ATTR_BASE + 29)
/** lcr display */
#define CMD_DISPLAY (CMD_ATTR_BASE + 33)
/** lcr sample count */
#define CMD_COUNT (CMD_ATTR_BASE + 34)
/** lcr correction mode */
#define CMD_CORRECTION_MODE (CMD_ATTR_BASE + 35)
/** Check ADC and FIFO overflow */
#define CMD_OVERFLOW_CHECK (CMD_ATTR_BASE + 36)
/** DC resistance mode */
#define CMD_RESISTANCE_MODE (CMD_ATTR_BASE + 37)
/** Enable Auto range gain for ADC channels */
#define CMD_ENABLE_AUTORANGE (CMD_ATTR_BASE + 38)
/** Minimum sample clocks   */
#define CMD_SAMPLE_CLOCKS (CMD_ATTR_BASE + 39)
/** Check echo mode is enabled or disabled   */
#define CMD_ECHO_MODE (CMD_ATTR_BASE + 40)
/** Sets and checks boards revision  */
#define CMD_BOARD_REV (CMD_ATTR_BASE + 41)
/** Trigger mode */
#define CMD_TRIGGER_MODE (CMD_ATTR_BASE + 42)
/** State of behaviour model  - only read allowed */
#define CMD_STATE ((CMD_ATTR_BASE + 45) | CMD_READ_BITM)
/** Actual measurement count value  */
#define CMD_ACTUAL_COUNT (CMD_ATTR_BASE + 47)
/** Check if vector display mode is enabled */
#define CMD_SELF_TEST_STATUS (CMD_ATTR_BASE + 49)
/** Unique ID -  addr0 - lower 32 , addr 1 upper 32 */
#define CMD_UNIQUE_ID (CMD_ATTR_BASE + 50)
/** Warning Message Type */
#define CMD_WARNING_TYPE (CMD_ATTR_BASE + 51)

/** Not defined or unsupported command */
#define CMD_NOT_DEFINED 0xFF

/** Bit mask for measure done bit  */
#define ADMX200X_STATUS_MEASURE_DONE_BITM 0x80000000
/** Bit mask for done field bits */
#define ADMX200X_STATUS_DONE_BITM 0x40000000
/** Bit mask for status field bits */
#define ADMX200X_STATUS_ERROR_BITM 0x20000000
/** Bit mask for warning field bits */
#define ADMX200X_STATUS_WARN_BITM 0x10000000
/** Bit mask for fifo error */
#define ADMX200X_STATUS_FIFO_ERROR_BITM 0x08000000
/** Bit mask for fifo depth  field bits */
#define ADMX200X_STATUS_FIFO_DEPTH_BITM 0x03FF0000
/** Bit mask for command result code field bits */
#define ADMX200X_STATUS_CODE_BITM 0x0000FFFF

/** Success */
#define ADMX_STATUS_SUCCESS 0
/** Failed */
#define ADMX_STATUS_FAILED 1
/** Timeout */
#define ADMX_STATUS_TIMEOUT 2
/** Invalid attribute */
#define ADMX_STATUS_INVALID_ATTRIBUTE 3
/** Attribute value out of range */
#define ADMX_STATUS_ATTR_OUT_OF_RANGE 4
/** Invalid address of tcommand */
#define ADMX_STATUS_INVALID_ADDRESS 5
/** Uncommitted calibration coeffs */
#define ADMX_STATUS_UNCOMMITED_CAL 6
/** Invalid current gain*/
#define ADMX_STATUS_INVALID_CURRENT_GAIN 7
/** Invalid display mode*/
#define ADMX_STATUS_INVALID_DISPLAY_MODE 8
/** Sweep type not valid */
#define ADMX_STATUS_INVALID_SWEEP_TYPE 9
/** Sweep type not valid in DC mode */
#define ADMX_STATUS_INVALID_DC_SWEEP_TYPE 9
/** Invalid sweep range */
#define ADMX_STATUS_INVALID_SWEEP_RANGE 10
/** Invalid calibration coeff type */
#define ADMX_STATUS_INVALID_CAL_COEFF_TYPE 11
/** System is not ready to take trigger */
#define ADMX_STATUS_TRIGGER_OVERFLOW 12
/** Invalid calibration type */
#define ADMX_STATUS_INVALID_CAL_TYPE 13
/** Invalid calibration gains */
#define ADMX_STATUS_INVALID_GAIN 14
/** WArning Auto range got disabled in this command */
#define ADMX_STATUS_AUTO_RANGE_DISABLED 15
/** Calibration faild */
#define ADMX_STATUS_CAL_FAILED 15
/** Compensation failed */
#define ADMX_STATUS_COMP_FAILED 15
/** Invalid command for the state */
#define ADMX_STATUS_INVALID_COMMAND_STATE 16
/** Log of zero error */
#define ADMX_STATUS_LOG_ZERO_ERROR 32
/** Sign change for log error */
#define ADMX_STATUS_LOG_SIGN_ERROR 64
/** Voltage ADC saturated error */
#define ADMX_STATUS_VOLT_ADC_ERROR 128
/** Current ADC saturated error */
#define ADMX_STATUS_CURR_ADC_ERROR 256
/** FIFO over/under flow error */
#define ADMX_STATUS_FIFO_ERROR 512
/** Sweep count maximum value exceeded */
#define ADMX_STATUS_COUNT_EXCEEDED 1024

#endif /* __ADMX200X_COMMANDS_H__ */
