/* Copyright (c) 2021 Analog Devices, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice, 
  this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice, 
  this list of conditions and the following disclaimer in the documentation 
  and/or other materials provided with the distribution.  
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors/products 
  manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner 
  that would cause the software to become subject to terms and conditions which 
  differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its contributors 
  may be used to endorse or promote products derived from this software without 
  specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one or 
  more patent holders.  This license does not release you from the requirement 
  that you obtain separate licenses from these patent holders to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT, 
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN 
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL 
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

2021-01-10-7CBSD SLA
*/
/**
 * @file     admx200x.h
 * @brief    This file contains admx200x APIs for sdpk1 host
 */
#ifndef __ADMX200X_H__
#define __ADMX200X_H__

/*=============  I N C L U D E S   =============*/
#include "platform_drivers.h"
#include <stdint.h>

/*=============   D  A T A T Y P E S  =============*/
/**
 * @brief The structure describes the device and is used with the admx2000x
 * driver.
 *
 */
typedef struct
{
    /** SPI */
    spi_desc *pSpiDesc;
    /** Add more elements in furture to describe device */

} Admx200xDev;

/**=============  D E F I N I T I O N S  =============*/
#define SPI_TIMEOUT 100
/*============= P U B L I C   P R O T O T Y P E S =============*/

/**  Initializes the ADMX200X. **/
int32_t Admx200xInit(Admx200xDev *pDevice, spi_desc *pSpiDesc);

int32_t Admx200xCreateCmdPayload(uint8_t *pCmdId, uint16_t *pAddr,
                                 uint32_t *pData, uint8_t *pBuffer);

int32_t Admx200xParseCmdPayload(uint8_t *pBuffer, uint8_t *pCmdId,
                                uint16_t *pAddr, uint32_t *pData);

int32_t Admx200xWaitForStatus(Admx200xDev *pDevice, uint32_t timeout,
                              uint32_t reqStatus, uint32_t *pStatReg);

int32_t Admx200xSendCmd(Admx200xDev *pDevice, uint8_t *pCmdId, uint16_t *pAddr,
                        uint32_t *pData, uint32_t *pStatReg);

int32_t Admx200xReadData(Admx200xDev *pDevice, uint8_t cmdId,
                         uint32_t *pResult);

int32_t Admx200xReadFifo(Admx200xDev *pDevice, double *pFifo, int32_t *pCount);

int32_t Admx200xClearSPI(Admx200xDev *pDevice);

#endif /* __ADMX200X_H__ */
