/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "pitches.h" //importar libreria:Buscar Buzz, selecciona el archivo Arch_Play_Music, copy y paste de la libreria
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define     Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      Barrido;                    // Interrupción del Timer
BusOut      Torreta(PC_10,PC_12,PA_13,PA_14,PA_15,PB_7,PC_2,PC_3); // Salidas de Puertos
DigitalOut  Led_Monitor (LED1);         // Led monitor de la Tarjeta NUCLEO_STM32F103
PwmOut      Buzzer(PB_0);               // PB0_TIM3_CH3N
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
int frequency[] = {NOTE_A3, NOTE_A4}; // Notas de la Libreria pitches.h
int beat[] = {2, 2 };             // Valor de la nota
uint8_t Secuencias[]={
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0, //   8
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0, //  16
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, //  24
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, //  32
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0xC0, //  40
        0xA0, 0xB0, 0xC0, 0xD0, 0x0D, 0x0C, 0x0B, 0x0A, //  48...
        
                                                        //  504
        };

uint16_t No_Secuencias=47;     // Número de secuencias a desplegar-------->AQUI SE CAMBIA EL NUMERO MAX DE SECUENCIAS 503
uint16_t i=0;                   // Indice para las secuencias
uint16_t delay=250;             // Tiempo de retardo entre secuencias (en ms)
uint16_t contador=0;            // Contador de mili segundos

/* END Global Variables */           
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{       // Inicialización de variables locales, puertos e interrupciones van aquí !!!
        // Inicialización del Sistema, 
Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Rate);   // Periodo de la Interrupción por Timer = 1ms (Tcker_Rate=1000)

while(true){
    for (int i = 0; i < (sizeof(frequency) / sizeof(int)); i++) {
        Buzzer.period(1.0 / frequency[i]);
        Buzzer.write(0.5);
        wait(1.0 / beat[i]);
        Buzzer.write(0);
        wait(0.05);
            }   
        }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()
{
    /* Rutina de Atención a la Interrupción */
    /* Write your code here ... */
    
    contador++;                     // Incremeta el contador de mili segundos
    if (contador == delay)          // Contador es igual al retardo programado?
    {
    Torreta=Secuencias[i];          // Escribe la secuencia
    i++;                            // Incrementa el índice
    if (i >= No_Secuencias) i=0;    // Es la última secuencia?
    contador =0;                    // Reinicia contador de retardo
    Led_Monitor = !Led_Monitor;     // Parpadeo del Led Monitor
    }
}
/* END Events */

/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Modificar este programa para: 
|       a) Agregar más secuencias (mínimo 504).

| 2.-   Modificar el programa para incluir secuencias de sonidos utiliando el 
|       módulo PWM (Sirena).
|       a) Agregar minino 8 Notas mas de sonido y modificar su valor.
+--------------------------------------------------------------------------------
*/