#include "mbed.h"
#include "EthernetInterface.h"
#include "Ambient.h"
#include "HDC1000.h"

unsigned int channelId = 100;
const char* writeKey = "ライトキー";
AMBIENT ambient;

HDC1000      hdc1000(p9,p10);

int main() {
    printf("start\r\n");

    EthernetInterface eth;
    eth.init();
    eth.connect();

    TCPSocketConnection socket;
    ambient.init(channelId, writeKey, &socket);

    printf("\n\rClient IP Address is %s\n\r", eth.getIPAddress());
    printf("Ambient send to ch: %d\r\n", channelId);

    while (true) {
        float temp, humid;
        char tempbuf[12], humidbuf[12];

        hdc1000.get();
        temp = hdc1000.temperature();
        humid = hdc1000.humidity();

        sprintf(tempbuf, "%2.1f", temp);
        ambient.set(1, tempbuf);
        sprintf(humidbuf, "%2.0f", humid);
        ambient.set(2, humidbuf);
        printf("Temp: %s C, Humid: %s %%\r\n", tempbuf, humidbuf);
        
        ambient.send();
        
        wait(30.0);
    }
}
