#include "mbed.h"

DigitalIn DI3(PB_7); // 1 od lewej //7
DigitalIn iReset(PB_6); // 2
DigitalIn iAwaria(PB_5); // 3
DigitalIn iStart(PB_4); // 4

//Wyjscia dyskretne - logika odwrotna - 1 - off; 0 - on

DigitalOut oAwaria(PB_3); // 8 AWARIA
DigitalOut oStart(PC_15); // 12 START
DigitalOut oReset(PC_14); // 11 RESET
DigitalOut oFire_minus(PB_9); // 10
DigitalOut oFire_plus(PB_8); //9 od prawej

//wejscia ciagle
//AnalogIn Analog1(PC_2);
AnalogIn Analog2(PC_1); //pierwszy od prawej (od zewnatrz)

Serial pc(PA_9, PA_10);

float Analog_medium=0;
float Analog_sum = 0;
float temp = 0;
float mocpalnika;

int a = 0;
int b = 0;
int c = 0;

void Regulator_Gazu(void)
{   
    Analog_sum = 0;
    for(int counter = 0; counter<30; counter ++){
        Analog_sum += Analog2.read();
    }
            
    Analog_medium = Analog_sum/30;
            
    oStart = 0; //wl. palnik (start)
        
    if(a < 60){
       
        oFire_plus = 1; //wyl. plus
        oFire_minus = 0; //wl. minus
        a ++;
        mocpalnika=0;
        b=0;
        c=0;
    }
    else{
        oFire_minus=1; //wyl. minus
        oFire_plus=1; //wyl. plus
            
        temp = Analog_medium/0.033f;
        if(mocpalnika < (temp-0.7)){
            if(b < 32) b++;

                switch(b){
                        
                    case 1:                        
                    if(mocpalnika < 30)mocpalnika++;
                    oFire_plus = 0;  
                    break;


                    case 10:
                    b=0; 
                    break;   
                            
                }
        }
        else{
            b=0;  
        }
            
        if(mocpalnika > (temp+1)){
            if(c < 10) c++;

            switch(c){
                        
                case 1:                        
                if(mocpalnika > 1)mocpalnika--;
                oFire_minus = 0;  
                break;


                case 10:
                c=0; 
                break;   
            }     
        }
        else{
            c=0;  
        }
    }
}


int main() {
    
    pc.printf("Przetwornik sygnalu palnika +/- -> 0-10V v. 1.0 \n\n\r");
    
    oStart = oReset = oFire_minus = oFire_plus = 1; // LED is ON
    wait(2.0); // 2s
    
    while(1) {
        
        if(iAwaria==1 and iStart==0)
        {
            pc.printf("\n\n\r");
            pc.printf("Wartosc analoga: %f\n\r", Analog_medium);
            Regulator_Gazu();
            pc.printf("Moc palnika: %f\n\r", mocpalnika);
            pc.printf("temp: %f\n\r", temp);
            pc.printf("a: %d\n\rb: %d\n\rc: %d\n\r", a, b, c);
            pc.printf("start: %d\n\rplus: %d\n\rminus: %d", oStart.read(), oFire_plus.read(), oFire_minus.read());
            wait(1.0);
        }
        else{
            oStart = 1;
            oFire_plus = 1;
            oFire_minus = 1;
            oAwaria = 0;
            a=0;
        }
    }
}
