// Tested: NUCLEO-F207ZG
#include "mbed.h"

// numero di acqusizioni su cui effettuare la media della temperatura
#define NUMSAMPLE 300

AnalogIn InWave(PA_0);
Serial pc(USBTX, USBRX);
DigitalOut myRele(PC_3);

// Output LED di diagnostica
DigitalOut led1(LED1); // verde
DigitalOut led2(LED2); // blu
DigitalOut led3(LED3); // rosso


// ticker per l'acquisizione dell'onda con ADC
Ticker SamplingTicker;

// carattere in arrivo dal PC ed equivalente numerico
volatile char cReadChar;
volatile int nReadChar;

// flag che diventa true quando si vuole fermare l'acquisizione
volatile bool bStop;

// valore letto dall'ADC e corrispondente in tensione
volatile unsigned short usReadADCLux;
volatile float fReadVoltage;

// valore di temperatura letto dall'ADC
volatile float fLux;
 
//***************************
// Acquisizione da ADC
//***************************
void Sampling() 
{
    // indice per i cicli
    int nIndex;
    // valore medio della temperatura su NUMACQUISISIONI acquisizioni
    float fAvgLux;
    
    // se è stato inviato il comando Stop, non fare niente fino a nuovo comando
    if(bStop)
    {
    }
    else // se non è stato inviato il comando di bStop continua
    {
        // inizializza il valore medio della temperatura 
        fAvgLux=0.0;
        for(nIndex=0; nIndex < NUMSAMPLE; nIndex++)
        {
            // acquisisce dato da ADC
            usReadADCLux = InWave.read_u16();
            fReadVoltage=(usReadADCLux*32767)/1.75; // converte in Volt il valore numerico letto dall'ADC
            //fReadVoltage=InWave.read(); // acquisisce il valore dall'ADC come valore di tensione in volt
            fLux=fReadVoltage;
            fAvgLux+=fLux;
        }   
        // calcola valore medio su NUMSAMPLE acquisizioni 
        fAvgLux/= NUMSAMPLE;
        
        if(fAvgLux < 0.9)
        {
          // accendi il relè sotto i 0.9 lux
          myRele =0x01 ; 
        }
        else
        {
         myRele =0x00 ;
        }
        } 
       
        pc.printf("\n\r--- Digital= %d [Volt]; Luminosita'= %.2f [Lux] ---\n\r", usReadADCLux, fLux);

     
    

        // invia il dato al PC     
     }




 //*******************
 // Loop Principale
 //*******************  
int main()
{
    // periodo di campionamento
    int nDeltaT;
    
        
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\nHey Bro! \r\n");
   // pc.printf("\r\n*** Bluetooth Temp Acquisition ***\r\n");
    
    // inizializza variabili
    bStop=true;
    
    /* test dei LED
    led1=1; //Verde
    wait_ms(1000);
    led1=0;
    led2=1; // Blu
    wait_ms(1000);
    led2=0;
    led3=1; //Rosso
    wait_ms(1000);
    led3=0;
    */
   
    
    while(true) 
    {
        
        
        // verifica se è arrivato un carattere dalla seriale del PC
        if(pc.readable())
        {
            cReadChar = pc.getc(); // Read hyperterminal
                    
            if((cReadChar == 'S') || (cReadChar == 's')) // blocca acquisizione se riceve 'S' oppure 's'
            {
                bStop= true;
                pc.printf("\n\r--- Acquisition Stopped ---\n\r");
            }    
            if((cReadChar >= '0') && (cReadChar <='9'))
            {
                bStop = false;
                nReadChar = cReadChar -'0'; //converte il carattere acquisito dal PC nel corrispondente valore numerico
                nDeltaT = nReadChar; // sampling Period in sec
                pc.printf("\n\r--- Acquisition Started DeltaT = %c ---\n\r", cReadChar);
                SamplingTicker.attach(&Sampling,nDeltaT);
            }        
        } //lettura da pc    
    } // while(true)
}