
#include "mbed.h"
#include<stdlib.h>
#define PACKETDIM   8
// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 9600); //Tx, Rx, bps // F401
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5

//carattere di comando ricevuto dal BLE e relativo parametro
volatile char cCommandBLE; // cambia nella routine di interrupt
volatile char cParamBLE; // cambia nella routine di interrupt
volatile int nParamBLE; // corrispondente valore numerico di cParamBLE

// memorizza l'ultimo comando ricevuto e relativo parametro. Ci saranno delle azioni solo se il comando ricevuto o il parametro è cambiato rispetto al precedente
char cOldCommandBLE;
int nOldParamBLE; 

// array per la ricezione dei messaggi da BLE
volatile char caRxPacket[PACKETDIM]; 
// contatore di caratteri ricevuti daBLE
volatile int nCharCount; 


/**********************************************/
//          IRQ associata a Rx da PC 
//**********************************************/
void pcRxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar; 
    
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = pc.getc(); // read character from PC
        //myBLE.putc(cReadChar); // Diagnostica: write char to BLE
        //pc.putc(cReadChar); // Diagnostica: write char to PC
        
        //pc.printf("W>: 0x%02x\n\r",cReadChar); // diagnostica
        if(cReadChar == '0') // se scrivo '0', invia questa stringa
        {
            // DIAGNOSTICA:
            // Invia Stringa di comando al Robot
            myBLE.printf("\r\n> Prova di Trasmissione \r\n");
         }
    }
}

//**********************************************/
//          IRQ associata a Rx da BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    
    // carattere ricevuto da BLE
    char cReadChar; 
    
    // indice per l'array di caratteri ricevuti
    int nCharIndex;
    
    // variabile ausiliaria
    int nAux;
    
    // flag che diventa true quando viene rilevata una incongruenza dei valori di Ro e Teta, presumibilmente dovuta a errori di comunicazione
    bool bIncongruenza;

    while((myBLE.readable()))
    {
        // acquisice stringa in input e memorizza in array
        cReadChar = myBLE.getc(); // Read character
        caRxPacket[nCharCount]=cReadChar;
        nCharCount++;
        //pc.printf("%c", cReadChar); // diagnostica
        
        // inizializza flag di incongruenza
        bIncongruenza = false;
        
        if(cReadChar==')')
        {
            //pc.printf("\r\n"); // diagnostica
            
            // +++++++++++++++++ INIZIO gestione Comando da Button +++++++++++++++++
            // Ho ricevuto il comando da un Button se il carattere numero 1, è una lettera maiuscola
            if((caRxPacket[1] > 0x40) && (caRxPacket[1] < 0x5B)) // caratteri alfabetici
            {
                cCommandBLE = caRxPacket[1]; // legge e memorizza il primo carattere
                nParamBLE = caRxPacket[2]-0x30;
                myLed=1; 
                // visualizza comando e parametro inviato da BLE
                //pc.printf("> %c%d \r\n\r",cCommandBLE, nParamBLE); // diagnostica
            }
            // +++++++++++++++++ FINE gestione Comando da Button +++++++++++++++++
            
            
        } // if(cReadChar == ')')
    }
}
            
            
/**********/
/*  MAIN  */
/**********/
int main()
{
    myLed = 0;
    while(true)
    {
        if((cCommandBLE != cOldCommandBLE) || (nParamBLE != nOldParamBLE))
        {
            switch (cCommandBLE)
            { 
                case 'T': // accendi/spegni LED su scheda
                {
                    myLed = 1;
                } break;                
                default: break;
            }
            //pc.printf("Comando = %c, Parametro = %d \r\n", cCommandBLE, nParamBLE); // diagnostica
            cOldCommandBLE = cCommandBLE;
            nOldParamBLE = nParamBLE;
        } 
    }     
}