// Tested: NUCLEO-F207ZG
#include "mbed.h"

// numero di acqusizioni su cui effettuare la media della temperatura
#define NUMSAMPLE 300

AnalogIn InWave(PA_0);
Serial pc(USBTX, USBRX);
//DigitalOut myRele(PC_3);

/*
//Output LED di diagnostica
DigitalOut led1(LED1); // verde
DigitalOut led2(LED2); // blu
DigitalOut led3(LED3); // rosso 
*/
DigitalOut LedAD (PC_2) ;
DigitalOut LedAS (PC_3) ;
DigitalOut LedPD (PC_10) ;
DigitalOut LedPS (PC_12) ;


// ticker per l'acquisizione dell'onda con ADC
Ticker SamplingTicker;

// carattere in arrivo dal PC ed equivalente numerico
volatile char cReadChar;
volatile int nReadChar;

// flag che diventa true quando si vuole fermare l'acquisizione
volatile bool bStop;

// valore letto dall'ADC e corrispondente in tensione
volatile unsigned short usReadADCLux;
volatile float fReadVoltage;

// valore di temperatura letto dall'ADC
volatile float fLux;
 
//***************************
// Acquisizione da ADC
//***************************
void Sampling() 
{
    // indice per i cicli
   // int nIndex;
    // valore medio della temperatura su NUMACQUISISIONI acquisizioni
    //float fAvgLux;
    /*
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01 ;
    //LedAS =0x01 ;
    //LedPD =0x01 ;
    //LedPS =0x01 ;
    wait(1);
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01;
    wait_ms(500);
    LedAS =0x01 ;
    wait_ms(500);
    LedPD =0x01 ;
    wait_ms(500);
    LedPS =0x01 ;
    wait(1);*/
    
    
    
    
    /*
    // se è stato inviato il comando Stop, non fare niente fino a nuovo comando
    if(bStop)
    {
    }
    else // se non è stato inviato il comando di bStop continua
    {
        // inizializza il valore medio della temperatura 
        fAvgLux=0.0;
        for(nIndex=0; nIndex < NUMSAMPLE; nIndex++)
        {
            // acquisisce dato da ADC
            usReadADCLux = InWave.read_u16();
            fReadVoltage=(usReadADCLux*32767)/1.75; // converte in Volt il valore numerico letto dall'ADC
            //fReadVoltage=InWave.read(); // acquisisce il valore dall'ADC come valore di tensione in volt
            fLux=fReadVoltage;
            fAvgLux+=fLux;
        }   
        // calcola valore medio su NUMSAMPLE acquisizioni 
        fAvgLux = fAvgLux/NUMSAMPLE;
        
        if(fAvgLux < 0.9)
        {
            // accendi il relè sotto i 0.9 lux
            myRele =0x01 ; 
            LedAD =0x01 ;
            LedAS =0x01 ;
            LedPD =0x01 ;
            LedPS =0x01 ;
        }
        else
        {
            // spegni il relè sopra i 0.9 lux
            myRele =0x00 ;
            LedAD =0x00 ;
            LedAS =0x00 ;
            LedPD =0x00 ;
            LedPS =0x00 ;
        }
        // invia il dato al PC
        pc.printf("\n\r--- Digital= %d [Volt]; Luminosita'= %.2f [Lux] ---\n\r", usReadADCLux, fAvgLux);
    } 

        // invia il dato al PC
        */     
}




 //*******************
 // Loop Principale
 //*******************  
int main()
{
    // periodo di campionamento
    int nDeltaT;
    
        
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\nHey Bro! Say Goodbye to your Sister !\r\n");
    pc.printf("Enter Acquisition Time, DeltaT[sec]= [1 - 9]: \r\n");
   // pc.printf("\r\n*** Bluetooth Temp Acquisition ***\r\n");
    
    // inizializza variabili
    bStop=true;
    //myRele = 0x00; // spegni il relè
    
    
     
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01 ;
    LedAS =0x01 ;
    LedPD =0x01 ;
    LedPS =0x01 ;
    wait(1);
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01;
    wait_ms(500);
    LedAS =0x01 ;
    wait_ms(500);
    LedPD =0x01 ;
    wait_ms(500);
    LedPS =0x01 ;
    wait(1);   
    /*
    while(true) 
    {
        // verifica se è arrivato un carattere dalla seriale del PC
        if(pc.readable())
        {
            // Read hyperterminal
            cReadChar = pc.getc(); 
                    
            // blocca acquisizione se riceve 'S' oppure 's'
            if((cReadChar == 'S') || (cReadChar == 's')) 
            {
                bStop= true;
                pc.printf("\n\r--- Acquisition Stopped ---\n\r");
            }    
            // il tempo di acquisizione può essere tra 1 e 9 secondi
            if((cReadChar >= '1') && (cReadChar <='9'))
            {
                bStop = false;
                nReadChar = cReadChar -'0'; //converte il carattere acquisito dal PC nel corrispondente valore numerico
                nDeltaT = nReadChar; // sampling Period in sec
                pc.printf("\n\r--- Acquisition Started DeltaT = %c ---\n\r", cReadChar);
                SamplingTicker.attach(&Sampling,nDeltaT);
            }        
        } //lettura da pc    
    } // while(true)
    */
}
